% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly2sample.R
\name{poly2sample}
\alias{poly2sample}
\title{poly2sample}
\usage{
poly2sample(x, y)
}
\arguments{
\item{x}{Object of class \emph{SpatialPolygons} or \emph{SpatialPolygonDataFrame}.}

\item{y}{A raster object or a numeric element.}
}
\value{
A \emph{SpatialPointsDataFrame} with sampled pixels reporting on polygon percent coverage.
}
\description{
{Converts a raster grid to points.}
}
\details{
{\emph{poly2Sample} extends on the \code{\link[raster]{rasterize}} function from the raster package making
it more efficient over large areas and converting its output into point samples rather than a raster object. For each
polygon in (\emph{"x"}), \emph{poly2sample} extracts the overlapping pixels of a reference grid. Then, for each pixel,
the function estimates the percentage of it that is covered by the reference polygon. If \emph{y} is a raster object, 
the function will use it as a reference  grid. If \emph{y} is a numeric element, the function will build a raster from 
the extent of \emph{x} and a resolution equal to \emph{y}.}
}
\examples{
{

 require(raster)

 # read raster data
 r <- raster(system.file("extdata", "ndvi.tif", package="fieldRS")[1])

 # read field data
 data(fieldData)
 fieldData <- fieldData[1,]

 # extract samples
 samples <- poly2sample(fieldData, r)

}
}
\seealso{
\code{\link{raster2sample}} \code{\link{ccLabel}}
}
