#' Data from Silverman et al. (2019) bioRxiv
#' 
#' Mock communities and calibration samples created for measuring and validating model
#' of PCR bias. This data has been preprocessed as in the original manuscript. 
#' 
#' @docType data
#' @name pcrbias_mock
#' @usage data(pcrbias_mock)
#' @format an matrix Y (counts for each community member) and a data.frame metadata
#' @references Justin D. Silverman, Rachael J. Bloom, Sharon Jiang, Heather K. Durand, Sayan Mukherjee, 
#' Lawrence A. David. (2019) Measuring and Mitigating PCR Bias in Microbiome Data. 
#' bioRxiv 604025; doi: https://doi.org/10.1101/604025
NULL



#' Data from Silverman et al. (2019) bioRxiv
#' 
#' Mock communities and calibration samples created for measuring and validating model
#' of PCR bias. This data has been preprocessed as in the original manuscript. 
#' 
#' @docType data
#' @name Y
#' @format an matrix Y (counts for each community member)
#' @references Justin D. Silverman, Rachael J. Bloom, Sharon Jiang, Heather K. Durand, Sayan Mukherjee, 
#' Lawrence A. David. (2019) Measuring and Mitigating PCR Bias in Microbiome Data. 
#' bioRxiv 604025; doi: https://doi.org/10.1101/604025
NULL

#' Data from Silverman et al. (2019) bioRxiv
#' 
#' Mock communities and calibration samples created for measuring and validating model
#' of PCR bias. This data has been preprocessed as in the original manuscript. 
#' 
#' @docType data
#' @name metadata
#' @format a data.frame metadata associated with the counts matrix `Y`
#' @references Justin D. Silverman, Rachael J. Bloom, Sharon Jiang, Heather K. Durand, Sayan Mukherjee, 
#' Lawrence A. David. (2019) Measuring and Mitigating PCR Bias in Microbiome Data. 
#' bioRxiv 604025; doi: https://doi.org/10.1101/604025
NULL