% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_plotdim.R
\name{guess_plotdim}
\alias{guess_plotdim}
\title{Guess plot dimensions.}
\usage{
guess_plotdim(x, accuracy = 20)
}
\arguments{
\item{x}{A ForestGEO-like dataframe: A \emph{ViewFullTable}, \emph{tree} or \emph{stem}
table.}

\item{accuracy}{A number giving the accuracy with which to round \code{gx} and
\code{gy}.}
}
\value{
A numeric vector of length 2.
}
\description{
Guess plot dimensions.
}
\examples{
x <- data.frame(
  gx = c(0, 300, 979),
  gy = c(0, 300, 481)
)
guess_plotdim(x)
}
\seealso{
Other functions for fgeo census and vft: 
\code{\link{pick_drop}}

Other functions for fgeo census: 
\code{\link{add_status_tree}()},
\code{\link{add_var}()},
\code{\link{pick_drop}}

Other functions for fgeo vft: 
\code{\link{add_status_tree}()},
\code{\link{add_subquad}()},
\code{\link{add_var}()},
\code{\link{pick_drop}}

Other functions for internal use in other fgeo packages: 
\code{\link{flag_if}()},
\code{\link{is_multiple}()}
}
\concept{functions for fgeo census}
\concept{functions for fgeo census and vft}
\concept{functions for fgeo vft}
\concept{functions for internal use in other fgeo packages}
\concept{general functions to find or approximate}
\keyword{internal}
