% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-sp_elev.R
\name{autoplot.sp_elev}
\alias{autoplot.sp_elev}
\alias{autoplot.sp}
\alias{autoplot.elev}
\title{Plot species distribution and/or topography.}
\usage{
\method{autoplot}{sp_elev}(object, fill = "sp",
  hide_fill_legend = FALSE, shape = 21, point_size = 3,
  facet = TRUE, contour_size = 0.5, low = "blue", high = "red",
  hide_color_legend = FALSE, bins = NULL,
  add_elevation_labels = TRUE, label_size = 3, label_color = "grey",
  xyjust = 1, fontface = "italic", xlim = NULL, ylim = NULL,
  custom_theme = NULL, ...)

\method{autoplot}{sp}(object, fill = "sp", hide_fill_legend = FALSE,
  shape = 21, point_size = 3, facet = TRUE, xlim = NULL,
  ylim = NULL, custom_theme = NULL, ...)

\method{autoplot}{elev}(object, contour_size = 0.5, low = "blue",
  high = "red", hide_color_legend = FALSE, bins = NULL,
  add_elevation_labels = TRUE, label_size = 3, label_color = "grey",
  xyjust = 1, fontface = "italic", xlim = NULL, ylim = NULL,
  custom_theme = NULL, ...)
}
\arguments{
\item{object}{An object created with \code{\link[=sp]{sp()}}, \code{\link[=elev]{elev()}}, or \code{\link[=sp_elev]{sp_elev()}}.}

\item{fill}{Character; either a color or "sp", which maps each species to a
different color.}

\item{hide_fill_legend}{Logical; \code{TRUE} hides the fill legend.}

\item{shape}{A number giving point shape (as in \code{\link[graphics:points]{graphics::points()}}). Passed
to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}

\item{point_size}{A number giving point size. Passed to
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}

\item{facet}{Logical; \code{TRUE} wraps multiple panels within the area of a single
graphic plot.}

\item{contour_size}{A number giving the size of the contour of elevation
lines. Passed to \code{ggplot2::stat_contour()} (see \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}).}

\item{low, high}{A string giving a color of the elevation lines representing
low and high elevation.}

\item{hide_color_legend}{Logical; \code{TRUE} hides the color legend.}

\item{bins}{A number giving the number of elevation lines to plot.}

\item{add_elevation_labels}{Logical; \code{FALSE} hides elevation labels.}

\item{label_size, label_color, fontface}{A number (\code{label_size}) or character
string (\code{label_color} and \code{fontface}) giving the size, colour and fontface
of the text labels for the elevation lines.}

\item{xyjust}{A number to adjust the position of the text labels of the
elevation lines.}

\item{xlim, ylim}{A vector of length 2, for example \code{c(0, 500)}, giving the
minimum and maximum limits of the vertical and horizontal coordinates.}

\item{custom_theme}{A valid \code{\link[ggplot2:theme]{ggplot2::theme()}}. \code{NULL} uses the default
theme \code{\link[=theme_default]{theme_default()}}.}

\item{...}{Not used (included for compatibility across methods).}
}
\value{
A "ggplot".
}
\description{
Plot the columns \code{sp} and/or \code{elev} of ForestGEO-like datasets of class 'sp'
and/or 'sp_elev'.
\itemize{
\item You can create a 'sp' \code{object} with:
}

\preformatted{    object <- sp(DATA-WITH-VARIABLE-sp)
}
\itemize{
\item You can create an 'elev' \code{object} with:
}

\preformatted{    object <- elev(DATA-WITH-VARIABLE-elev)
}

\itemize{
\item You can create a 'sp_elev' \code{object} with:
}

\preformatted{    object <- sp_elev(DATA-WITH-VARIABLE-sp, DATA-WITH-VARIABLE-elev)
}

See \strong{Examples} below.
}
\details{
\code{autoplot(sp_elev(DATA-WITH-VARIABLE-sp)} (without elevation data) is
equivalent to \code{autoplot(sp(DATA-WITH-VARIABLE-sp))}.

\strong{fgeo.plot} wraps some functions from the \strong{ggplot2} package.
For more control you can use \strong{ggplot2} directly.
}
\examples{
assert_is_installed("fgeo.x")

# Species ---------------------------------------------------------------

# Small dataset with a few species for quick examples
census <- fgeo.x::tree5 \%>\%
  subset(sp \%in\% c("PREMON", "CASARB"))

autoplot(sp(census))

# Skip R CMD check for speed
\donttest{
# Customize
autoplot(sp(census), point_size = 1)

# Elevation -------------------------------------------------------------

elevation <- fgeo.x::elevation
autoplot(elev(elevation))  

# Skip R CMD check for speed
# Same as `autoplot(elev(elevation))`
autoplot(elev(elevation$col))

# Customize
autoplot(elev(elevation), contour_size = 1)

# Species and elevation -------------------------------------------------
autoplot(sp_elev(census, elevation), facet = FALSE, point_size = 1)
}
}
\seealso{
Other plot functions: \code{\link{autoplot.fgeo_habitat}},
  \code{\link{autoplot_by_species.sp_elev}},
  \code{\link{elev}},
  \code{\link{plot_dbh_bubbles_by_quadrat}},
  \code{\link{plot_tag_status_by_subquadrat}},
  \code{\link{sp_elev}}, \code{\link{sp}}

Other autoplots: \code{\link{autoplot.fgeo_habitat}},
  \code{\link{elev}}, \code{\link{sp_elev}},
  \code{\link{sp}}

Other functions to plot elevation: \code{\link{autoplot_by_species.sp_elev}},
  \code{\link{elev}}, \code{\link{sp_elev}}

Other functions to plot species: \code{\link{autoplot_by_species.sp_elev}},
  \code{\link{sp_elev}}, \code{\link{sp}}
}
\concept{autoplots}
\concept{functions to plot elevation}
\concept{functions to plot species}
\concept{plot functions}
