% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_detectAFFMeanSinglePrechange}
\alias{cpp_detectAFFMeanSinglePrechange}
\title{Find the first changepoint in the mean using AFF, assuming prechange known}
\usage{
cpp_detectAFFMeanSinglePrechange(x, alpha, eta, prechangeMean, prechangeSigma)
}
\arguments{
\item{x}{Vector of numeric values values.}

\item{alpha}{Value for the significance threshold in \eqn{(0,1)}.}

\item{eta}{Value for the step size in \eqn{(0,1)}.}

\item{prechangeMean}{Value of known prechange mean.}

\item{prechangeSigma}{Value of known prechange standard deviation.}
}
\value{
A list with 
\describe{
            \item{\code{tauhat}}{The index of the first changepoint found.}
         }
}
\description{
Given a vector \code{x}, a threshold \code{alpha}, a step size \code{eta}, 
and a burn-in length BL, returns a list containing the single changepoint.
Algorithm is implemented in C++.
}
\keyword{internal}

