% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_best}
\alias{get_best}
\alias{get_start}
\alias{get_interp}
\alias{get_interp_last}
\alias{get_anchor}
\alias{get_search}
\alias{get_dir_search}
\alias{get_space_param}
\alias{get_theo}
\alias{get_interrupt}
\alias{get_search_count}
\alias{get_basis_matrix}
\title{Functions to get components from the data collecting object}
\usage{
get_best(dt, group = NULL)

get_start(dt, group = NULL)

get_interp(dt, group = NULL)

get_interp_last(dt, group = NULL)

get_anchor(dt, group = NULL)

get_search(dt)

get_dir_search(dt, ratio = 5, ...)

get_space_param(dt, ...)

get_theo(dt)

get_interrupt(dt, group = NULL, precision = 0.001)

get_search_count(dt, iter = NULL, group = NULL)

get_basis_matrix(dt)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{group}{the variable to label different runs of the optimiser(s)}

\item{ratio}{numeric; a buffer value to deviate directional search points from the anchor points}

\item{...}{other arguments passed to \code{compute_pca()}}

\item{precision}{numeric; if the index value of the last interpolating point and the anchor point differ by \code{precision}, an interruption is registered}

\item{iter}{the variable to be counted by}
}
\value{
a tibble object containing the best basis found by the optimiser(s)
}
\description{
Functions to get components from the data collecting object
}
\details{
\code{get_best}: extract the best basis found by the optimiser(s)

\code{get_start}: extract the start point of the optimisation

\code{get_interp}: extract the interpolation points

\code{get_interp_last}: extract the last point in each interpolation

\code{get_anchor}: extract the anchor points on the geodesic path

\code{get_search}: extract search points in the optimisation (for
\code{search_geodesic})

\code{get_dir_search}: extract directional search points (for
\code{search_geodesic})

\code{get_space_param}: estimate the radius of the background circle
based on the randomly generated points. The space of projected bases is a
circle when reduced to 2D. A radius is estimated using the largest distance
from the bases in the data object to the centre point.

\code{get_theo}: extract the theoretical basis, if exist

\code{get_interrupt}: extract the end point of the interpolation and the
target point in the iteration when an interruption happens. The optimiser
can find better basis on the interpolation path, an interruption is
implemented to stop further interpolation from the highest point to the
target point. This discrepancy is highlighted in the PCA plot.

\code{get_search_count}: summarise the number of search points in each iteration

\code{get_basis_matrix}: extract all the bases as a matrix
}
\examples{
get_search(holes_1d_geo)

get_anchor(holes_1d_geo)

get_start(holes_1d_better)

get_interrupt(holes_1d_better)

get_interp(holes_1d_better) \%>\% head()

get_basis_matrix(holes_1d_better) \%>\% head()

get_best(dplyr::bind_rows(holes_1d_better, holes_1d_geo), group = method)

get_search_count(holes_1d_better)
get_search_count(dplyr::bind_rows(holes_1d_better, holes_1d_geo), group = method)

get_interp_last(holes_1d_better)
get_interp_last(dplyr::bind_rows(holes_1d_better, holes_1d_geo), group = method)

res <- holes_1d_geo \%>\% compute_pca() \%>\% purrr::pluck("aug")
get_dir_search(res)

best <- matrix(c(0, 1, 0, 0, 0), nrow = 5)
holes_1d_better \%>\%
  bind_theoretical(best, tourr::holes(), raw_data = boa5) \%>\%
  get_theo()
}
