% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind_theoretical}
\alias{bind_theoretical}
\title{Bind the theoretical best record}
\usage{
bind_theoretical(dt, matrix, index, raw_data)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{matrix}{a matrix of the theoretical basis}

\item{index}{the index function used to calculate the index value}

\item{raw_data}{a tibble of the original data used to calculate the index value}
}
\value{
a tibble object containing both the searched and theoretical best bases
}
\description{
The theoretical best basis is usually known for a simulated problem.
Augment this information into the data object allows for evaluating the performance of optimisation against the theory.
}
\examples{
best <- matrix(c(0, 1, 0, 0, 0), nrow = 5)
tail(holes_1d_better \%>\% bind_theoretical(best, tourr::holes(), raw_data = boa5), 1)
}
\seealso{
Other bind: 
\code{\link{bind_random_matrix}()},
\code{\link{bind_random}()}
}
\concept{bind}
