% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{frequentwords}
\alias{frequentwords}
\title{Frequent words}
\usage{
frequentwords(
  corpus,
  nb,
  mincount = 5,
  minphrasecount = NULL,
  ngram = 1,
  lang = "en",
  stopwords = lang
)
}
\arguments{
\item{corpus}{The corpus of documents (a vector of characters) or the vocabulary of the documents (result of function \code{getvocab}).}

\item{nb}{The number of words to be returned.}

\item{mincount}{Minimum word count to be considered as frequent.}

\item{minphrasecount}{Minimum collocation of words count to be considered as frequent.}

\item{ngram}{maximum size of n-grams.}

\item{lang}{The language of the documents (NULL if no stemming).}

\item{stopwords}{Stopwords, or the language of the documents. NULL if stop words should not be removed.}
}
\value{
The most frequent words of the corpus.
}
\description{
Most frequent words of the corpus.
}
\examples{
\dontrun{
text = loadtext ("http://mattmahoney.net/dc/text8.zip")
frequentwords (text, 100)
vocab = getvocab (text)
frequentwords (vocab, 100)
}
}
\seealso{
\code{\link{getvocab}}
}
