% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{stability}
\alias{stability}
\title{Clustering evaluation through stability}
\usage{
stability(
  clusteringmethods,
  d,
  originals = NULL,
  eval = "jaccard",
  comp = c("cluster", "max"),
  nsampling = 10,
  seed = NULL,
  names = NULL,
  graph = FALSE,
  ...
)
}
\arguments{
\item{clusteringmethods}{The clustering methods to be evaluated.}

\item{d}{The dataset.}

\item{originals}{The original clustering.}

\item{eval}{The evaluation criteria.}

\item{comp}{The comparison method.}

\item{nsampling}{The number of bootstrap runs.}

\item{seed}{A specified seed for random number generation (useful for testing different method with the same bootstap samplings).}

\item{names}{Method names.}

\item{graph}{Indicates wether or not a graphic is potted for each sample.}

\item{...}{Parameters to be passed to the clustering algorithms.}
}
\value{
The evaluation of the clustering algorithm(s) (numeric values).
}
\description{
Evaluation a clustering algorithm according to stability, through a bootstrap procedure.
}
\examples{
require (datasets)
data (iris)
stability (KMEANS, iris [, -5], seed = 0, k = 3)
stability (KMEANS, iris [, -5], seed = 0, k = 3, eval = c ("jaccard", "accuracy"), comp = "max")
stability (KMEANS, iris [, -5], seed = 0, k = 3, comp = "cluster")
stability (KMEANS, iris [, -5], seed = 0, k = 3, eval = c ("jaccard", "accuracy"), comp = "cluster")
stability (c (KMEANS, HCA), iris [, -5], seed = 0, k = 3)
stability (c (KMEANS, HCA), iris [, -5], seed = 0, k = 3,
eval = c ("jaccard", "accuracy"), comp = "max")
stability (c (KMEANS, HCA), iris [, -5], seed = 0, k = 3, comp = "cluster")
stability (c (KMEANS, HCA), iris [, -5], seed = 0, k = 3,
eval = c ("jaccard", "accuracy"), comp = "cluster")
stability (KMEANS, iris [, -5], originals = KMEANS (iris [, -5], k = 3)$cluster, seed = 0, k = 3)
stability (KMEANS, iris [, -5], originals = KMEANS (iris [, -5], k = 3), seed = 0, k = 3)
}
\seealso{
\code{\link{compare}}, \code{\link{intern}}
}
