% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dens2qd.R
\name{dens2qd}
\alias{dens2qd}
\title{Function for converting Densities to Quantile Densities}
\usage{
dens2qd(dens, dSup = seq(0, 1, length.out = length(dens)), qdSup = seq(0, 1,
  length.out = length(dens)), useSplines = TRUE)
}
\arguments{
\item{dens}{density on dSup}

\item{dSup}{support for Density domain - max and min values mark the boundary of the support.}

\item{qdSup}{support for quantile density domain - must begin at 0 and end at 1}

\item{useSplines}{fit spline to the qd when doing the numerical integration (default: TRUE)}
}
\value{
qd quantile density values on qdSup
}
\description{
Function for converting Densities to Quantile Densities
}
\examples{

x <- seq(0,2,length.out =512)
y <- rep(0.5,length.out =512)
y.qd <- dens2qd(dens=y, dSup = x) # should equate # 2

}
\references{
\cite{Functional Data Analysis for Density Functions by Transformation to a Hilbert space, Alexander Petersen and Hans-Georg Mueller, 2016}
}
