% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcr_methods.R
\name{predict.fcr}
\alias{predict.fcr}
\title{Prediction for fcr}
\usage{
\method{predict}{fcr}(object, newdata, type = "link", ...)
}
\arguments{
\item{object}{object of class fcr.}

\item{newdata}{data frame including all predictors used in the model fitting procedure.
missing values for the responses are OK. Missing covariate values will result in pairwise deletion with
a warning message.}

\item{type}{defaults to link (i.e. response). See \code{\link{predict.gam}} for additional information.}

\item{...}{additional arguments to be passed to \code{\link{predict.gam}}}
}
\value{
An object containing two elements
\describe{
\item{dynamic_predictions}{Predictions corresponding to dynamic predictions (i.e. subject ids not included in the original fitting).
 Note that these predictions are slower and do not incorporate the estimated covariance between random effects and fixed effects in making
 predictions. This is different than the in sample predictions which account for this estimated covariance. See \code{\link{predict.gam}}
 for more information.

 \itemize{
 \item fitted.values
   \itemize{
   \item y.pred fitted \eqn{\hat{y}}
   \item se.fit standard errors used to create confidence intervals for \eqn{\hat{y}}, \eqn{\sqrt{var(y)}}
   \item se.fit.p standard errors used for creating prediction intervals for \eqn{\hat{y}}, \eqn{\sqrt{var(y) + \hat{\sigma^2}}}
   \item random subject specific random effects \eqn{b_i}

   }
 \item scores matrix of BLUPs for subjects' eigenscores
 \item data newdata supplied to the function

 }

 }
\item{insample_predictions}{Predictions for subject ids included in the original fitting. This returns all output from the relevant
\code{\link{predict.gam}}/\code{\link{predict.bam}} call. }}
}
\description{
Predict method for \code{\link{fcr}}
}
\examples{
## see examples in fcr

}
