\name{wilson.hilferty}
\alias{wilson.hilferty}
\title{Wilson-Hilferty transformation}
\description{
  Returns the Wilson-Hilferty transformation of random variables with chi-squared distribution.
}
\usage{
  wilson.hilferty(x)
}
\arguments{
  \item{x}{ vector or matrix of data with, say, \eqn{p} columns.}
}
\details{
  Let \eqn{F} the following random variable:
  \deqn{F = \frac{D^2/p}{1-2\eta}}{F = D^2/(p(1-2\eta))}
  where \eqn{D^2} denotes the squared Mahalanobis distance defined as
  \deqn{D^2 = (\bold{x} - \bold{\mu})^T \bold{\Sigma}^{-1} (\bold{x} - \bold{\mu})}

  Thus the Wilson-Hilferty transformation is given by
  \deqn{z = \frac{F^{1/3} - (1 - \frac{2}{9p})}{(\frac{2}{9p})^{1/2}}}
  and \eqn{z} is approximately distributed as a standard normal distribution. This
  is useful, for instance, in the construction of QQ-plots.
}
\references{
  Wilson, E.B., and Hilferty, M.M. (1931).
  The distribution of chi-square.
  \emph{Proceedings of the National Academy of Sciences of the United States of America} \bold{17}, 684-688.
}
\seealso{\code{\link{cov}}, \code{\link{Mahalanobis}}}
\examples{
x <- iris[,1:4]
z <- wilson.hilferty(x)
par(pty = "s")
qqnorm(z, main = "Transformed distances Q-Q plot")
abline(c(0,1), col = "red", lwd = 2, lty = 2)
}
\keyword{multivariate}
