% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycleGAN_models.R
\name{CycleGANLoss}
\alias{CycleGANLoss}
\title{CycleGANLoss}
\usage{
CycleGANLoss(cgan, l_A = 10, l_B = 10, l_idt = 0.5, lsgan = TRUE)
}
\arguments{
\item{cgan}{The CycleGAN model.}

\item{l_A}{lambda_A, weight of domain A losses. (default=10)}

\item{l_B}{lambda_B, weight of domain B losses. (default=10)}

\item{l_idt}{lambda_idt, weight of identity lossees. (default=0.5)}

\item{lsgan}{Whether or not to use LSGAN objective (default=True)}
}
\description{
CycleGAN loss function. The individual loss terms are also atrributes
of this class that are accessed by fastai for recording during training.
}
\details{
Attributes: `self.cgan` (`nn.Module`): The CycleGAN model.
`self.l_A` (`float`): lambda_A, weight of domain A losses.
`self.l_B` (`float`): lambda_B, weight of domain B losses.
`self.l_idt` (`float`): lambda_idt, weight of identity lossees.
`self.crit` (`AdaptiveLoss`): The adversarial loss function
(either a BCE or MSE loss depending on `lsgan` argument)
`self.real_A` and `self.real_B` (`fastai.torch_core.TensorImage`): Real images from domain A and B.
`self.id_loss_A` (`torch.FloatTensor`): The identity loss for domain A calculated
in the forward function `self.id_loss_B` (`torch.FloatTensor`): The identity loss for domain B calculated
in the forward function `self.gen_loss` (`torch.FloatTensor`): The generator loss calculated
in the forward function `self.cyc_loss` (`torch.FloatTensor`): The cyclic loss calculated
in the forward function
}
