% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasim.R
\name{simulate_count_data}
\alias{simulate_count_data}
\title{Simulate Count Data from Poisson NMF Model}
\usage{
simulate_count_data(n, m, k, fmax = 1, lmax = 1, sparse = FALSE)
}
\arguments{
\item{n}{Number of rows in simulated count matrix. The number of
rows should be at least 2.}

\item{m}{Number of columns in simulated count matrix. The number of
columns should be at least 2.}

\item{k}{Number of factors, or \dQuote{topics}, used to determine
Poisson rates. The number of topics should be 1 or more.}

\item{fmax}{Factors are drawn uniformly at random between zero and
\code{fmax}.}

\item{lmax}{Loadings are drawn uniformly at random between zero and
\code{lmax}.}

\item{sparse}{If \code{sparse = TRUE}, convert the counts matrix to
a sparse matrix in compressed, column-oriented format; see
\code{\link[Matrix]{sparseMatrix}}.}
}
\value{
The return value is a list containing the counts matrix
  \code{X} and the factorization, \code{F} and \code{L}, used to
  generate the counts.
}
\description{
Simulate a counts matrix \code{X} such that
  \code{X[i,j]} is Poisson with rate (mean) \code{Y[i,j]}, where
  \code{Y = tcrossprod(L,F)}, \code{L} is an n x k loadings
  (\dQuote{activations}) matrix, and \code{F} is an m x k factors
  (\dQuote{basis vectors}) matrix. The entries of matrix \code{L} are
  drawn uniformly at random between zero and \code{lmax}, and the
  entries of matrix \code{F} are drawn uniformly at random between 0
  and \code{fmax}.
}
\details{
Note that only minimal argument checking is performed. This
  function is mainly used to simulate small data sets for the examples
  and package tests.
}
