% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_plots.R
\name{plot_progress}
\alias{plot_progress}
\title{Plot Progress of Model Fitting Over Time}
\usage{
plot_progress(
  fits,
  x = c("timing", "iter"),
  y = c("loglik", "dev", "res"),
  add.point.every = 20,
  colors = c("#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7"),
  linetypes = "solid",
  linesizes = 0.5,
  shapes = 19,
  fills = "white",
  e = 0.01,
  theme = function() theme_cowplot(12)
)
}
\arguments{
\item{fits}{An object of class \code{"poisson_nmf_fit"} or
\code{"multinom_topic_model_fit"}, or a non-empty, named list in
which each all list elements are objects of class
\code{"poisson_nmf_fit"} or all objects of class
\code{"multinom_topic_model_fit"}.}

\item{x}{Choose \code{"timing"} to plot improvement in the solution
over time, or choose \code{"iter"} to plot improvement in the
solution per iteration.}

\item{y}{Column of the "progress" data frame used to assess
progress of the Poisson NMF optimization method(s). Should be one
of \code{"loglik"} (Poisson NMF or multinomial topic model
log-likelihood), \code{"dev"} (deviance) or \code{"res"} (maximum
residual of KKT conditions). The deviance is only valid for Poisson
NMF model fits.}

\item{add.point.every}{A positive integer giving the iteration
interval for drawing points on the progress curves. Set to
\code{Inf} to prevent points from being drawn on the plot.}

\item{colors}{Colours used to draw progress curves; passed as the
\code{values} input to \code{\link[ggplot2]{scale_color_manual}}.
If fewer colours than "fits" are given, the colours are recycled.}

\item{linetypes}{Line types used to draw progress curves; passed as
the \code{values} input to \code{\link[ggplot2]{scale_linetype_manual}}.
If fewer line types than \dQuote{fits} are given, the line types are
recycled.}

\item{linesizes}{Line sizes used to draw progress curves; passed as
the \code{values} input to \code{\link[ggplot2]{scale_size_manual}}.
If fewer line sizes than \dQuote{fits} are given, the line sizes are
 recycled.}

\item{shapes}{Shapes used to draw points at the selected
iterations; passed as the \code{values} input to
\code{\link[ggplot2]{scale_shape_manual}}. If fewer shapes than
\dQuote{fits} are given, the shapes are recycled.}

\item{fills}{Fill colours used to draw points at the selected
iterations; passed as the \code{values} input to
\code{\link[ggplot2]{scale_fill_manual}}. If fewer fill colours
than \dQuote{fits} are given, the fill colours are recycled.}

\item{e}{A small, positive number added to the vertical axis (for
\code{y = "loglik"} and \code{y = "dev"} only) so that the
logarithmic scale does not over-emphasize very small differences.}

\item{theme}{The \sQuote{ggplot2} \dQuote{theme}.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a plot showing improvement in one or more
  Poisson NMF or multinomial topic model fits over time.
}
\details{
The horizontal axis shows the recorded runtime (in s), and
the vertical axis shows some quantity measuring the quality of the
fit: the log-likelihood, deviance or maximum residual of the
Karush-Kuhn-Tucker (KKT) first-order optimality conditions. To
better visualize log-likelihoods and deviances, log-likelihood and
deviance differences are shown on the logarithmic scale.
Differences are calculated with respect to the best value achieved
over all the fits compared.

Note that only minimal argument checking is performed.
}
\seealso{
\code{\link{fit_poisson_nmf}}
}
