% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Trebuchet}
\alias{Trebuchet}
\alias{Trebuchet1}
\alias{Trebuchet2}
\title{Trebuchet data}
\format{Data frames with the following variables.  \itemize{
\item{object}{ the object serving as projectile\code{bean} \code{big
washerb} \code{bigWash} \code{BWB} \code{foose} \code{golf} \code{MWB}
\code{SWB} \code{tennis ball} \code{wood}}
\item{projectileWt}{ weight of projectile (in grams)}
\item{counterWt}{ weight of counter weight (in kg)}
\item{distance}{ distance projectile traveled (in cm)}
\item{form}{ a factor with levels \code{a} \code{b} \code{B} \code{c}
describing the configuration of the trebuchet.} }}
\source{
Data collected by Andrew Pruim as part of a Science Olympiad
competition.
}
\description{
Measurements from an experiment that involved firing projectiles with a
small trebuchet under different conditions.
}
\details{
\code{Trebuchet1} and \code{Trebuchet2} are subsets of \code{Trebuchet} restricted
to a single value of \code{counterWt}
}
\examples{

data(Trebuchet); data(Trebuchet1); data(Trebuchet2)
gf_point(distance ~ projectileWt, data = Trebuchet1)
gf_point(distance ~ projectileWt, data = Trebuchet2)
gf_point(distance ~ projectileWt, color = ~ factor(counterWt), data = Trebuchet) \%>\%
  gf_smooth(alpha = 0.2, fill = ~factor(counterWt))

}
\keyword{datasets}
