% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMoversPriors.R
\name{calcMoversPriors}
\alias{calcMoversPriors}
\title{calcMoversPriors}
\usage{
calcMoversPriors(geo.a, geo.b, year.start, year.end,
county, state.a, state.b, matchrate.lambda, remove.instate)
}
\arguments{
\item{geo.a}{The state code (if state = TRUE) or county name
(if state = FALSE) for the earlier of the two voter files.}

\item{geo.b}{The state code (if state = TRUE) or county name
(if state = FALSE) for the later of the two voter files.}

\item{year.start}{The year of the voter file for geography A.}

\item{year.end}{The year of the voter file for geography B.}

\item{county}{Whether prior is being calculated on the county or state level.
Default is FALSE (for a state-level calculation).}

\item{state.a}{If \code{county = TRUE} (indicating a county-level match),
the state code of \code{geo.a}. Default is NULL.}

\item{state.b}{If \code{county = TRUE} (indicating a county-level match),
the state code of \code{geo.b}. Default is NULL.}

\item{matchrate.lambda}{If TRUE, then returns the match rate for lambda
(the expected share of observations in dataset A that can be found in
dataset B). If FALSE, then returns the expected share of matches across
all pairwise comparisons of datasets A and B. Default is FALSE}

\item{remove.instate}{If TRUE, then for calculating cross-state movers rates
assumes that successful matches have been subsetted out. The interpretation
of the prior is then the match rate conditional on being an out-of-state or
county mover. Default is TRUE.}
}
\value{
\code{calcMoversPriors} returns a list with estimates of the expected
match rate, and of the expected in-state movers rate when matching within-state.
}
\description{
calcMoversPriors calculates prior estimates of in-state and
cross-state movers rates from the IRS SOI Migration data,
which can be used to improve the accuracy of the EM algorithm.
}
\examples{
calcMoversPriors(geo.a = "CA", geo.b = "CA", year.start = 2014, year.end = 2015)

}
\author{
Ben Fifield <benfifield@gmail.com>
}
