/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import jfm.lp.LPPeer;
import jfm.lp.LPX;
import jfm.lp.Matrix;

final class GLPKPeer
extends LPPeer {
    private Matrix.PrimitiveMatrix matrix;
    private long lpobj = 0L;

    private native long create(double[] var1, double[] var2, double[] var3, int[] var4, double[] var5, int[] var6, int[] var7, double[] var8, int[] var9, int[] var10, char[][] var11, char[][] var12);

    private native void setTermOut(long var1, int var3);

    private native void destroy(long var1);

    private native int solveWithNewCoefficients(double[] var1, double[] var2, double[] var3, int[] var4, int[] var5, long var6);

    private native int solveWithNewProblem(double[] var1, double[] var2, double[] var3, int[] var4, double[] var5, int[] var6, int[] var7, double[] var8, int[] var9, int[] var10, char[][] var11, char[][] var12, long var13);

    protected GLPKPeer(Matrix matrix_) {
        super(LPPeer.Solver.GLPK);
        this.matrix = matrix_.primitiveMatrix;
        this.lpobj = this.create(this.matrix.solution, this.matrix.structure, this.matrix.columnBounds, this.matrix.columnBoundTypes, this.matrix.matrixElements, this.matrix.matrixRowIndexes, this.matrix.matrixColIndexes, this.matrix.rowBounds, this.matrix.rowBoundTypes, this.matrix.columnTypes, this.matrix.rowNames, this.matrix.colNames);
    }

    protected LPX solve() {
        int status = this.matrix.constraintsChanged ? this.solveWithNewProblem(this.matrix.solution, this.matrix.structure, this.matrix.columnBounds, this.matrix.columnBoundTypes, this.matrix.matrixElements, this.matrix.matrixRowIndexes, this.matrix.matrixColIndexes, this.matrix.rowBounds, this.matrix.rowBoundTypes, this.matrix.columnTypes, this.matrix.rowNames, this.matrix.colNames, this.lpobj) : this.solveWithNewCoefficients(this.matrix.solution, this.matrix.structure, this.matrix.columnBounds, this.matrix.columnBoundTypes, this.matrix.columnTypes, this.lpobj);
        this.matrix.acceptChanges();
        this.matrix.commitSolution();
        return LPX.intToGLPKType(status);
    }

    public void setTermOut(LPX flag) {
        if (flag != LPX.LPX_TERMOFF && flag != LPX.LPX_TERMON) {
            throw new Error("Only LPX_TERMON or LPX_TERMOFF are allowed ");
        }
        this.setTermOut(this.lpobj, flag.toCPP());
    }

    public synchronized void destroy() {
        if (this.lpobj != 0L) {
            this.destroy(this.lpobj);
            this.lpobj = 0L;
        }
    }

    public void finalize() {
        this.destroy();
    }

    static {
        String jlpath = System.getProperty("java.library.path");
        System.out.println(jlpath);
        System.loadLibrary("farmR");
        System.out.println("Loaded");
    }
}

