/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jfm.lp.ModelPrimitive;
import jfm.model.CropInput;
import jfm.model.Formula;
import jfm.model.Location;
import jfm.model.Operation;
import jfm.model.Rotation;
import jfm.model.Types;
import jfm.utils.MathPrint;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Crop {
    private final List<CropCopy> yearCopies = new ArrayList<CropCopy>();
    private double primaryPrice = 0.0;
    private double secondaryPrice = 0.0;
    private double subsidy = 0.0;
    private double priceRisk = 0.0;
    private double yieldRisk = 0.0;
    private double eostdev = 0.0;
    private Formula primaryYield = new Formula("0");
    private Formula secondaryYield = new Formula("0");
    private Map<Types.VariableType, CropInput> inputCosts = new HashMap<Types.VariableType, CropInput>();
    private double[] yieldReductions = new double[]{0.0};
    private double[] selfRotCosts = new double[]{0.0};
    public final Types.CropType type;
    public final Types.DiseaseType diseaseType;
    public final boolean continuousCroppingAllowed;
    private boolean formulaVariablesSet = false;
    private final Rotation rotation;
    private double approximateFixedCostsPerHectare = 200.0;

    Crop copy() {
        List<Operation> theops = this.yearCopies.get(0).operations();
        Crop cpy = new Crop(this.type, this.diseaseType, this.rotation.copy(), this.continuousCroppingAllowed);
        HashMap<Types.VariableType, CropInput> inputsCopy = new HashMap<Types.VariableType, CropInput>();
        for (CropInput in : this.inputCosts.values()) {
            inputsCopy.put(in.associatedVariable, in.copy());
        }
        cpy.setGrossMarginDetails(this.primaryYield.copy(), this.secondaryYield.copy(), this.primaryPrice, this.secondaryPrice, this.subsidy, this.priceRisk, this.yieldRisk, inputsCopy);
        cpy.setSuccessiveRotationCosts(this.yieldReductions, this.selfRotCosts);
        for (Operation op : theops) {
            cpy.addOperation(op.copy());
        }
        return cpy;
    }

    public Crop(Types.CropType cropType_, Types.DiseaseType diseaseType_, Rotation rotation_, boolean allowContinuous) {
        this.type = cropType_;
        this.rotation = rotation_;
        this.diseaseType = diseaseType_;
        this.continuousCroppingAllowed = allowContinuous;
        this.createCopies();
    }

    public Rotation rotation() {
        return this.rotation;
    }

    public void setSuccessiveRotationCosts(double[] yieldReductions_, double[] selfRotCosts_) {
        if (yieldReductions_.length != selfRotCosts_.length) {
            throw new Error("Yield Reductions and Self Rotation Costs must be vectors of equal length");
        }
        int size = yieldReductions_.length;
        this.yieldReductions = new double[size];
        this.selfRotCosts = new double[size];
        for (int i = 0; i < size; ++i) {
            this.yieldReductions[i] = yieldReductions_[i];
            this.selfRotCosts[i] = selfRotCosts_[i];
        }
        this.createCopies();
    }

    private void createCopies() {
        this.yearCopies.clear();
        CropCopy nextcrop = new CropCopy(this);
        nextcrop.setYear(0);
        this.yearCopies.add(nextcrop);
        int ncopies = this.yieldReductions.length;
        for (int i = 1; i < ncopies; ++i) {
            nextcrop = nextcrop.createNextCrop();
            this.yearCopies.add(nextcrop);
        }
    }

    void deRegisterCopies() {
        for (CropCopy cpyp : this.yearCopies) {
            cpyp.deRegister();
            for (Operation op : cpyp.operations()) {
                op.deRegister();
            }
        }
    }

    public void addOperation(Operation newOp) {
        for (CropCopy cp : this.yearCopies) {
            cp.addOperation(newOp.copy());
        }
    }

    public List<CropCopy> getYearCopies() {
        return Collections.unmodifiableList(this.yearCopies);
    }

    public CropCopy getCopy(int year) {
        if (this.yearCopies.size() > year) {
            return this.yearCopies.get(year);
        }
        throw new Error("The requested crop year " + year + " is not defined for " + (Object)((Object)this.type));
    }

    private void setFormulaVariables() {
        if (this.yearCopies.get(0).isRegistered()) {
            Location loc = this.yearCopies.get(0).getLocation();
            this.setFormulaVariables(loc);
        }
    }

    public void setFormulaVariables(Location loc) {
        for (CropInput cinp : this.inputCosts.values()) {
            this.primaryYield.setVariable(cinp.associatedVariable, cinp.getVariable(cinp.associatedVariable));
            this.secondaryYield.setVariable(cinp.associatedVariable, cinp.getVariable(cinp.associatedVariable));
        }
        this.primaryYield.setVariable(Types.VariableType.SOILTYPE, loc.getVariable(Types.VariableType.SOILTYPE));
        this.primaryYield.setVariable(Types.VariableType.RAINFALL, loc.getVariable(Types.VariableType.RAINFALL));
        this.secondaryYield.setVariable(Types.VariableType.SOILTYPE, loc.getVariable(Types.VariableType.SOILTYPE));
        this.secondaryYield.setVariable(Types.VariableType.RAINFALL, loc.getVariable(Types.VariableType.RAINFALL));
        this.formulaVariablesSet = true;
    }

    private void recalculateGrossMargins() {
        this.setFormulaVariables();
        for (CropCopy cp : this.yearCopies) {
            cp.recalculateGrossMargin();
        }
    }

    public void resetPrimaryYield(String newYieldFormulaString) {
        this.primaryYield.parse(newYieldFormulaString);
        this.recalculateGrossMargins();
    }

    public void resetSecondaryYield(String newYieldFormulaString) {
        this.secondaryYield.parse(newYieldFormulaString);
        this.recalculateGrossMargins();
    }

    public void resetPrimaryPrice(double newP) {
        this.primaryPrice = newP;
        this.recalculateGrossMargins();
    }

    public void resetPriceRisk(double r) {
        this.priceRisk = r * 0.01;
    }

    public void resetYieldRisk(double r) {
        this.yieldRisk = r * 0.01;
    }

    public void resetEOStandardDeviation(double eostdev_) {
        this.eostdev = eostdev_;
    }

    public void resetApproximateFixedCostsPerHectare(double fc) {
        this.approximateFixedCostsPerHectare = fc;
    }

    public void resetInputCost(Types.VariableType inputType, double newUnitCost) {
        CropInput inVar = this.inputCosts.get((Object)inputType);
        if (inVar != null) {
            inVar.setUnitCost(newUnitCost);
            this.recalculateGrossMargins();
        }
    }

    public double getPrimaryPrice() {
        return this.primaryPrice;
    }

    public double getSolvedArea() {
        double total = 0.0;
        for (CropCopy cp : this.yearCopies) {
            total += cp.getSolvedArea();
        }
        return total;
    }

    public void resetSecondaryPrice(double newP) {
        this.secondaryPrice = newP;
        this.recalculateGrossMargins();
    }

    public void resetSubsidy(double newS) {
        this.subsidy = newS;
        this.recalculateGrossMargins();
    }

    public void resetInput(Types.VariableType vtype, CropInput inp) {
        this.inputCosts.put(vtype, inp);
        this.recalculateGrossMargins();
    }

    public Collection<CropInput> inputSet() {
        return Collections.unmodifiableCollection(this.inputCosts.values());
    }

    public void setGrossMarginDetails(Formula primY, Formula secY, double primP, double secP, double subs, double prisk_, double yrisk_, Map<Types.VariableType, CropInput> inputs) {
        this.priceRisk = prisk_;
        this.yieldRisk = yrisk_;
        this.primaryYield = primY;
        this.secondaryYield = secY;
        this.primaryPrice = primP;
        this.secondaryPrice = secP;
        this.subsidy = subs;
        this.inputCosts = inputs;
        this.recalculateGrossMargins();
    }

    void checkFormulaVariablesSet() {
        if (!this.formulaVariablesSet) {
            throw new Error("Attempt to calculate formula of crop but variables not yet set for formula ");
        }
    }

    public double getPrimaryYield() {
        this.checkFormulaVariablesSet();
        return this.primaryYield.calculateValue();
    }

    double getSecondaryYield() {
        this.checkFormulaVariablesSet();
        return this.secondaryYield.calculateValue();
    }

    public String printFormulaCheck(Location loc) {
        StringBuffer buff = new StringBuffer();
        buff.append("Yield1: " + MathPrint.df3.format(this.primaryYield.calculateValue()) + "\n");
        buff.append("Yield2: " + MathPrint.df3.format(this.secondaryYield.calculateValue()) + "\n");
        for (Operation op : this.yearCopies.get(0).operations) {
            buff.append((Object)((Object)op.type) + ": " + MathPrint.df3.format(op.workrate(loc)) + "\n");
        }
        buff.append("\n");
        return buff.toString();
    }

    public String toString() {
        StringBuffer outstring = new StringBuffer();
        outstring.append("Crop: ");
        outstring.append((Object)this.type);
        outstring.append(" ");
        outstring.append("Price: ");
        outstring.append(this.primaryPrice);
        outstring.append(" ");
        outstring.append("Yield: ");
        outstring.append(this.primaryYield);
        outstring.append(" ");
        outstring.append("Subsidy: ");
        outstring.append(this.subsidy);
        outstring.append(" Disease Class: " + (Object)((Object)this.diseaseType));
        outstring.append("Num copies " + this.yearCopies.size() + "\n");
        outstring.append(this.yearCopies.get(0) + "\n");
        return outstring.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CropCopy
    extends ModelPrimitive {
        private int copyYear = 0;
        private final Crop parentCrop;
        private Operation handOverOperation = null;
        private final List<Operation> operations = new ArrayList<Operation>();

        public Location getLocation() {
            if (this.isRegistered()) {
                return this.parentComponent.getParent().location();
            }
            return null;
        }

        CropCopy(Crop parent) {
            this.parentCrop = parent;
        }

        List<Operation> operations() {
            return Collections.unmodifiableList(this.operations);
        }

        public double getVARRisk(double alpha, double offset) {
            double var;
            if (this.parentCrop.type == Types.CropType.SETASIDE) {
                return 0.0;
            }
            double stdEO = Crop.this.eostdev * 0.01 * this.grossOutputLessSubsidy();
            if (stdEO == 0.0) {
                return 0.0;
            }
            double meanEO = this.grossMargin();
            NormalDistributionImpl ndist = new NormalDistributionImpl(meanEO, stdEO);
            try {
                var = ndist.inverseCumulativeProbability(alpha);
            }
            catch (MathException ex) {
                throw new Error(ex.getMessage());
            }
            var = var - this.totalInputs() - Crop.this.selfRotCosts[this.copyYear] - Crop.this.approximateFixedCostsPerHectare - offset;
            if (var > 0.0) {
                var = 0.0;
            }
            return var;
        }

        public double getMOTADRisk() {
            if (this.parentCrop.type == Types.CropType.SETASIDE) {
                return 0.0;
            }
            double stdEO = Crop.this.eostdev * 0.01 * this.grossOutputLessSubsidy() * 1.0;
            return stdEO;
        }

        @Override
        public String name() {
            return Crop.this.type.name;
        }

        private double totalInputs() {
            double total = 0.0;
            for (CropInput in : Crop.this.inputCosts.values()) {
                if (in.associatedVariable == Types.VariableType.TRANSPORT) {
                    total += in.getCost(this.copyYear) * Crop.this.getPrimaryYield() * (1.0 - Crop.this.yieldReductions[this.copyYear]);
                    continue;
                }
                total += in.getCost(this.copyYear);
            }
            return total;
        }

        public double getSolvedArea() {
            return this.getSolution()[0];
        }

        private double grossOutputLessSubsidy() {
            return this.grossMargin() + this.totalInputs() + Crop.this.selfRotCosts[this.copyYear] - Crop.this.subsidy;
        }

        private double grossMargin(double yieldPenalty) {
            double marg = 0.0;
            double mod = 1.0 - Crop.this.yieldReductions[this.copyYear] - yieldPenalty;
            return marg += (Crop.this.primaryPrice * Crop.this.primaryYield.calculateValue() + Crop.this.secondaryPrice * Crop.this.secondaryYield.calculateValue()) * mod + Crop.this.subsidy - this.totalInputs() - Crop.this.selfRotCosts[this.copyYear];
        }

        public double baseGrossMargin() {
            double marg = 0.0;
            double mod = 1.0;
            return marg += (Crop.this.primaryPrice * Crop.this.primaryYield.calculateValue() + Crop.this.secondaryPrice * Crop.this.secondaryYield.calculateValue()) * mod + Crop.this.subsidy - this.totalInputs() - Crop.this.selfRotCosts[this.copyYear];
        }

        Types.DiseaseType diseaseType() {
            return Crop.this.diseaseType;
        }

        Types.CropType type() {
            return Crop.this.type;
        }

        Crop baseCrop() {
            return this.parentCrop;
        }

        double costOfYieldPenalty(double yieldPenalty, Location loc) {
            return (Crop.this.primaryYield.calculateValue() * Crop.this.primaryPrice + Crop.this.secondaryYield.calculateValue() * Crop.this.secondaryPrice) * yieldPenalty;
        }

        private void recalculateGrossMargin() {
            if (this.parentComponent != null) {
                if (!this.parentComponent.getParent().needsRebuild()) {
                    this.setCoefficient(Types.ObjectiveType.PROFIT, this.grossMargin(), 0);
                } else {
                    this.setCoefficient(Types.ObjectiveType.PROFIT, this.grossMargin(), 0);
                }
            }
        }

        double grossMargin() {
            return this.grossMargin(0.0);
        }

        @Override
        protected void updateStructure(Object caller) {
            this.recalculateGrossMargin();
            for (Operation op : this.operations) {
                op.updateStructure(this);
            }
        }

        public Map<String, Double> getProfitSummary(boolean useMarginals) {
            LinkedHashMap<String, Double> profits = new LinkedHashMap<String, Double>();
            double div = 1.0;
            if (useMarginals) {
                div = this.solvedArea();
            }
            profits.put("Total", (this.grossMargin() * this.solvedArea() - this.operationPenaltyCost() - this.operationFuelCost()) / div);
            profits.put("Gross", this.grossMargin() * this.solvedArea() / div);
            profits.put("OpPenalty", -this.operationPenaltyCost() / div);
            profits.put("OpFuel", -this.operationFuelCost() / div);
            profits.put("Area", this.solvedArea());
            return profits;
        }

        public String getDetailedProfitBreakdown(int columnWidth) {
            StringBuffer buff = new StringBuffer();
            DecimalFormat d1 = new DecimalFormat("#0");
            String rowTitleFormat = "%1$30s";
            String rEF = "%1$15.1f";
            buff.append(this.name() + " " + this.copyYear + "\n");
            buff.append(String.format(rowTitleFormat, "Base Value:"));
            buff.append(String.format(rEF, this.solvedArea() * this.grossMargin()) + " " + d1.format(this.grossMargin()) + " " + d1.format(this.totalInputs()) + "\n");
            buff.append(String.format(rowTitleFormat, "Rotation Cost:"));
            double[] yieldAndCostPenalties = this.parentComponent.getParent().rotations.getSolvedRotationPenaltyForCrop(this, this.parentComponent.getParent().location());
            buff.append(String.format(rEF, -yieldAndCostPenalties[0]));
            buff.append(String.format(rEF, -yieldAndCostPenalties[1]) + "\n");
            for (Operation op : this.operations) {
                buff.append(String.format(rowTitleFormat, (Object)((Object)op.type) + ":"));
                buff.append(String.format(rEF, -op.solvedFuelCost()));
                buff.append(String.format(rEF, -op.solvedPenaltyCost()) + "\n");
            }
            buff.append("\n\n");
            return buff.toString();
        }

        private double operationPenaltyCost() {
            double cost = 0.0;
            for (Operation op : this.operations) {
                cost += op.solvedPenaltyCost();
            }
            return cost;
        }

        private double operationFuelCost() {
            double cost = 0.0;
            for (Operation op : this.operations) {
                cost += op.solvedFuelCost();
            }
            return cost;
        }

        double grossMarginLossForYieldPenalty(double penalty) {
            return this.grossMargin() - this.grossMargin(penalty);
        }

        double solvedArea() {
            return this.getDependent(0).solution();
        }

        Operation handOverOperation() {
            if (this.handOverOperation == null) {
                throw new Error("No hand over operation defined for crop " + this.name() + " " + this.copyYear);
            }
            return this.handOverOperation;
        }

        void addOperation(Operation newOp) {
            if (this.operations.contains(newOp)) {
                throw new Error("The Operation has already been added ");
            }
            if (newOp.isHandOver()) {
                this.handOverOperation = newOp;
            }
            newOp.attachToCrop(this);
            this.operations.add(newOp);
        }

        CropCopy createNextCrop() {
            if (!this.hasNext()) {
                throw new Error("Attempt to createNextCrop when the maximum number of copies has already been reached");
            }
            CropCopy cp = new CropCopy(this.parentCrop);
            cp.setYear(this.copyYear + 1);
            return cp;
        }

        private boolean hasNext() {
            return Crop.this.yieldReductions.length > this.copyYear + 1;
        }

        private void setYear(int ny) {
            this.copyYear = ny;
        }

        int copyYear() {
            return this.copyYear;
        }

        public String toString() {
            StringBuffer outstring = new StringBuffer();
            outstring.append("Crop: ");
            outstring.append(this.name());
            for (Operation op : this.operations) {
                outstring.append(op + "\n");
            }
            return outstring.toString();
        }

        String printSolution(char sep) {
            Location loc = this.parentComponent.getParent().location();
            StringBuffer buff = new StringBuffer();
            buff.append(this.name() + "\n");
            for (Operation op : this.operations) {
                buff.append(op.printSolution(sep));
                buff.append('\n');
            }
            return buff.toString();
        }
    }
}

