% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_other.R
\name{logret}
\alias{logret}
\alias{logret.matrix}
\alias{logret.data.frame}
\title{Computes the log returns of a vector-valued time series}
\usage{
\method{logret}{matrix}(dat, demean = FALSE, standardize = FALSE, ...)

\method{logret}{data.frame}(dat, demean = FALSE, standardize = FALSE, ...)

logret(dat, demean = FALSE, standardize = FALSE, ...)
}
\arguments{
\item{dat}{The raw data, a matrix or data frame with \code{n}
(number of timepoints) rows and \code{m}
(number of component series) columns.}

\item{demean}{Logical value indicating whether the data should
be de-meaned.}

\item{standardize}{Logical value indicating whether the data should
be standardized (in the sense that each component series has an empirical
variance equal to one).}

\item{...}{Ignored.}
}
\value{
Matrix containing the log returns of the (de-meaned)
data.
}
\description{
\code{logret} computes the log returns of a multivariate time
series, with optional de-meaning.
}
