% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.tbl_ts}
\alias{autoplot.tbl_ts}
\alias{autolayer.tbl_ts}
\title{Plot time series from a tsibble}
\usage{
\method{autoplot}{tbl_ts}(object, .vars = NULL, ...)

\method{autolayer}{tbl_ts}(object, .vars = NULL, ...)
}
\arguments{
\item{object}{A tsibble.}

\item{.vars}{A bare expression containing data you wish to plot. Multiple variables can be plotted using \code{\link[ggplot2:vars]{ggplot2::vars()}}.}

\item{...}{Further arguments passed to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}, which can be used to specify fixed aesthetics such as \code{colour = "red"} or \code{size = 3}.}
}
\description{
Produces a time series plot of one or more variables from a tsibble. If the
tsibble contains a multiple keys, separate time series will be identified by
colour.
}
\examples{
\dontshow{if (requireNamespace("fable", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(fable)
library(tsibbledata)
library(tsibble)

tsibbledata::gafa_stock \%>\%
 autoplot(vars(Close, log(Close)))
\dontshow{\}) # examplesIf}
}
