% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongRun.R
\name{LongRun}
\alias{LongRun}
\title{Long Run Covariance Operator Estimation for Functional Time Series}
\usage{
LongRun(fdobj, h, kern_type = "BT", is_change = TRUE, ...)
}
\arguments{
\item{fdobj}{A functional data object}

\item{h}{The bandwidth parameter. It is strictly non-zero. Choosing the bandwidth parameter to be zero is identical
to estimating covariance operator assuming iid data.}

\item{kern_type}{Kernel function to be used for the estimation of the long run covariance
function. The choices are \code{c("BT", "PR", "SP", "FT")} which are respectively, bartlett, parzen, simple and flat-top kernels.
By default the function uses a \code{"barlett"} kernel.}

\item{is_change}{If \code{TRUE} then the data is centered considering the change in the mean function.}

\item{...}{Further arguments to pass}
}
\value{
\item{\code{e_fun}}{
Eigenfunctions of the estimated long run covariance function
}
\item{\code{e_val}}{
Eigenvalues of the estimated long run covariance function
}
\item{\code{covm}}{
Coefficient matrix of the estimated long run covariance operator.
}
\item{\code{contour_plot}}{
The estimated covariance function \eqn{C(t,s)} surface plot if \code{plot=TRUE}
}
}
\description{
This function estimates the long run covariance operator of a given functional data sample and its estimated eigenelements.
}
\examples{
# Generate FAR(1) process
fdata = fun_AR(n=100, nbasis=31, order=1, kappa=0.9)
# Estimate the Long run covrariance
C_hat = LongRun(fdata, h=2)
C_hat$e_fun # eigenfunctions of Long Run Cov
C_hat$e_val # eigenvalues of Long Run Cov
C_hat$covm # Estimated covariance matrix

}
\references{
Aue A., Rice G., Sonmez O. (2017+), \emph{Detecting and dating structural breaks in
functional data without dimension reduction} (https://arxiv.org/pdf/1511.04020.pdf)

Rice G. and Shang H. L. (2017), \emph{A plug-in bandwidth selection procedure for
long run covariance estimation with stationary functional time series}, Journal of Time Series Analysis, 38(4), 591-609
}
\seealso{
\code{\link{opt_bandwidth}}
}
