% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cov_test.R
\name{Cov_test}
\alias{Cov_test}
\title{Testing the Equality of Covariance Operators in Functional Samples}
\usage{
Cov_test(fdobj1, fdobj2, d)
}
\arguments{
\item{fdobj1}{A functional data object of class '\code{fd}'}

\item{fdobj2}{A functional data object of class '\code{fd}'}

\item{d}{Level ofdimension reduction needed to represent the data. One can use \code{pick_dim}}
}
\value{
\item{\code{pvalue}}{
Approximate p value for testing equality of the covariance structures in two functional samples
}
}
\description{
This function tests  for the equality of the covariance structures in two functional samples.
}
\details{
test for the equality of the covariance structures
in two functional samples. The test statistic has a chi-square asymptotic distribution
with a known number of degrees of freedom, which depends on the level of
dimension reduction needed, \code{d}, to represent the data.
}
\examples{
# generate functional data
fdata1 = fun_IID(n=100, nbasis=21)
fdata2 = fun_IID(n=150, nbasis=21)
Cov_test(fdata1, fdata2, d=5)



}
\references{
Fremdt S., Horvath L., Kokoszka P., Steinebach J. (2017+), \emph{Testing the Equality of Covariance Operators in
Functional Samples} Scandinavian Journal of Statistics, 2013.
}
\seealso{
\code{\link{change_fPCA}}
}
