% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_standings.R
\name{load_standings}
\alias{load_standings}
\title{Load Standings}
\usage{
load_standings(season = get_current_season(), round = "last", type = "driver")
}
\arguments{
\item{season}{number from 2003 to current season (defaults to current season).}

\item{round}{number from 1 to 23 (depending on season), and defaults
to most recent. Also accepts \code{'last'}.}

\item{type}{select \code{'driver'} or \code{'constructor'} championship data. Defaults to
\code{'driver'}}
}
\value{
A tibble with columns driver_id (or constructor_id), position,
points, wins (and constructors_id in the case of drivers championship).
}
\description{
Loads standings at the end of a given season and round for drivers' or
constructors' championships. Use \code{.load_standings()} for an uncached version of this function.
}
