\name{getSelectionName.ezsim}
\alias{getSelectionName.ezsim}
\title{Get Names of selection Parameters.}
\usage{
  \method{getSelectionName}{ezsim}(x,simple=FALSE,parameters_priority,...)
}
\arguments{
  \item{x}{an ezsim object}

  \item{simple}{If true, return only the name of selection
  parameters. If False, split the selection into two
  groups, one with fixed value, one with varied value.
  Also, subtitle is returned.}

  \item{parameters_priority}{Priority in sorting
  parameters.}

  \item{\dots}{unused}
}
\value{
  \item{selection_length_greater_one}{ Name of selection
  parameters with more than one elements}
  \item{selection_length_one}{Name of selection parameters
  with only one element} \item{subtitle}{subtitle for fixed
  selection parameters}
}
\description{
  Get names of selection parameters from an ezsim object.
}
\note{
  For internal use of ezsim.
}
\examples{
\dontrun{
ezsim_basic<-ezsim(
    m             = 100,
    run           = TRUE,
    display_name  = c(mean_hat="hat(mu)",sd_mean_hat="hat(sigma[hat(mu)])"),
    parameter_def = createParDef(list(n=seq(20,80,20),mu=c(0,2),sigma=c(1,3,5))),
    dgp           = function() rnorm(n,mu,sigma),
    estimator     = function(x) c(mean_hat = mean(x),
                                 sd_mean_hat=sd(x)/sqrt(length(x)-1)),
    true_value    = function() c(mu, sigma / sqrt(n-1))
)

getSelectionName(ezsim_basic)
getSelectionName(summary(ezsim_basic))
}
}
\author{
  TszKin Julian Chan \email{ctszkin@gmail.com}
}
\seealso{
  \code{\link{getSelectionName.summary.ezsim}}
}
\keyword{internal}

