% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_sequence_data.R
\name{analyze_time_bins}
\alias{analyze_time_bins}
\alias{analyze_time_bins.time_sequence_data}
\title{analyze_time_bins()}
\usage{
analyze_time_bins(data, ...)

\method{analyze_time_bins}{time_sequence_data}(data, predictor_column, test,
  threshold = NULL, alpha = 0.05, formula = NULL, return_model = FALSE,
  quiet = FALSE, ...)
}
\arguments{
\item{data}{The output of the 'make_time_sequence_data' function}

\item{...}{Any other arguments to be passed to the selected 'test' function (e.g.,
paired, var.equal, etc.)}

\item{predictor_column}{The variable whose test statistic you are interested in. If you are not 
interested in a predictor, but the intercept, you can enter "intercept" for this argument.
Interaction terms are not currently supported.}

\item{test}{What type of test should be performed in each time bin? Supports 
\code{t.test}, \code{wilcox.test}, \code{lm}, and \code{lmer}.}

\item{threshold}{Value of statistic used in determining significance}

\item{alpha}{Alpha value for determining significance, ignored if threshold is given}

\item{formula}{What formula should be used for the test? Optional for all but
\code{lmer}, if unset will use \code{Prop ~ [predictor_column]}. Change this to use a custom DV.}

\item{return_model}{In the returned dataframe, should a model be given for each time bin, or
just the summary of those models?}

\item{quiet}{Should messages and progress bars be suppressed? Default is to show}
}
\value{
A dataframe indicating the results of the test at each time-bin.
}
\description{
Runs a test on each time-bin of \code{time_sequence_data}. Supports \code{t.test}, \code{wilcox.test}, \code{lm}, and
\code{lmer}. By default, uses 'proportion-looking' (\code{Prop}) as the DV, which can be changed by manually specifying the formula.
Results can be plotted to see how test-results or parameters estimates vary over time.
}
\section{Methods (by class)}{
\itemize{
\item \code{time_sequence_data}: 
}}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)
response_time <- make_time_sequence_data(data, time_bin_size = 250, 
                                         predictor_columns = c("MCDI_Total"),
                                         aois = "Animate", summarize_by = "ParticipantName")
tb_analysis <- analyze_time_bins(response_time, predictor_column = "MCDI_Total", 
                                 test = "lm", threshold = 2)
summary(tb_analysis)
  
}

