% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_aois.R
\name{extract_AOIs}
\alias{extract_AOIs}
\alias{extract_AOIs.data.frame}
\alias{extract_AOIs.eyelinkRecording}
\title{Extracts rectangular areas of interest (AOI)}
\usage{
extract_AOIs(object)

\method{extract_AOIs}{data.frame}(object)

\method{extract_AOIs}{eyelinkRecording}(object)
}
\arguments{
\item{object}{Either an \code{\link{eyelinkRecording}} object or data.frame with events,
i.e., \code{events} slot of the \code{\link{eyelinkRecording}} object.}
}
\value{
Object of the same time as input, i.e., either a \code{\link{eyelinkRecording}} object
with an additional \code{AOIs} slot or a data.frame with AOIs' information. See
\code{\link{eyelinkRecording}} for details.
}
\description{
Extracts rectangular areas of interest (AOI),
as defined by \code{"!V IAREA RECTANGLE"} command.
Specifically, we expect it to be in format
\code{!V IAREA RECTANGLE <index> <left> <top> <right> <bottom> <label>},
where \code{<label>} is a string label and all other variables are integer.
Please note that due to a non-standard nature of this function \strong{is not} called
during the \code{\link{read_edf}} call and you need to call it separately.
}
\examples{
data(gaze)

# by passing the recording
gaze <- extract_AOIs(gaze)

# by passing events table
AOIs <- extract_AOIs(gaze$events)
}
