% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radf-tidiers.R
\name{tidy.radf_cv}
\alias{tidy.radf_cv}
\alias{augment.radf_cv}
\title{Tidy a \code{radf_cv} object}
\usage{
\method{tidy}{radf_cv}(x, format = c("wide", "long"), ...)

\method{augment}{radf_cv}(x, format = c("wide", "long"), trunc = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{radf_cv}.}

\item{format}{Long or wide format (default = "wide").}

\item{...}{Further arguments passed to methods. Not used.}

\item{trunc}{Whether to remove the period of the minimum window from the plot (default = TRUE).}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}

\itemize{
\item id: The series names.
\item sig: The significance level.
\item name: The name of the series (when format is "long").
\item crit: The critical value (when format is "long").
}
}
\description{
Summarizes information about \code{radf_cv} object.
}
\examples{
\donttest{
mc <- radf_mc_cv(100)

# Get the critical values
tidy(mc)

# Get the critical value sequences
augment(mc)

}
}
