% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantGPD.R
\name{quantGPD}
\alias{quantGPD}
\title{Fast GPD quantile estimate}
\usage{
quantGPD(x, probs = c(0.8, 0.9, 0.99), truncate = 0,
  threshold = berryFunctions::quantileMean(x, truncate), addn = TRUE,
  quiet = FALSE, ...)
}
\arguments{
\item{x}{Vector with numeric values. NAs are silently ignored.}

\item{probs}{Probabilities. DEFAULT: c(0.8,0.9,0.99)}

\item{truncate, threshold}{Truncation proportion or threshold. DEFAULT: 0, computed
See \code{\link{q_gpd}}.}

\item{addn}{Logical: add element with sample size (after truncation). DEFAULT: TRUE}

\item{quiet}{Should messages from this function be suppressed? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{lmomco::\link[lmomco]{pargpa}}}
}
\value{
Vector with quantiles
}
\description{
Fast GPD quantile estimate through L-moments
}
\examples{
data(annMax)
quantile(annMax, 0.99)
quantGPD(annMax, 0.99)

\dontrun{ # Excluded from CRAN checks to reduce checking time
data(rain, package="ismev") ;  rain <- rain[rain>0]
hist(rain, breaks=50, col=7)
tr <- seq(0,0.999, len=50)
qu <- pbapply::pbsapply(tr, quantGPD, x=rain, probs=c(0.9,0.99,0.999) ) # 30 s
plot(tr, qu[3,], ylim=range(rain), las=1, type="l")
lines(tr, qu[2,], col=2); lines(tr, qu[1,], col=4)

tr <- seq(0.88,0.999, len=50)
qu <- pbapply::pbsapply(tr, quantGPD, x=rain, probs=c(0.9,0.99,0.999) ) # 5 s
plot(tr, qu[3,], ylim=range(rain), las=1, type="l")
lines(tr, qu[2,], col=2); lines(tr, qu[1,], col=4);
tail(qu["n",])

library(microbenchmark)
data(rain, package="ismev"); rain <- rain[rain>0]
mb <- microbenchmark(quantGPD(rain[1:200], truncate=0.8, probs=0.99, addn=F),
distLquantile(rain[1:200], sel="gpa", emp=F, truncate=0.8, quiet=T, probs=0.99)[1,1]
)
boxplot(mb)
# since computing the lmoments takes most of the computational time,
# there's not much to optimize in large samples like n=2000

}

}
\seealso{
\code{\link{q_gpd}} for a comparison across R packages and methods, \code{\link{distLquantile}} to compare distributions
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2017
}
\keyword{distribution}
\keyword{robust}
\keyword{univar}
