test_that("ran_pois", {
  expect_error(ran_pois(NA_integer_))
  expect_error(ran_pois(integer(0)))
  expect_identical(ran_pois(0L), integer(0))
  set.seed(101)
  expect_identical(ran_pois(), 1L)
  expect_identical(ran_pois(2), c(0L, 1L))
  expect_identical(ran_pois(2, 10), c(11L, 8L))
  expect_identical(ran_pois(2, c(0.1,100)), c(0L, 103L))
  expect_identical(ran_pois(1, c(0.1,100)), 0L)
})

test_that("ran_pois_zi", {
  expect_error(ran_pois_zi(NA_integer_))
  expect_error(ran_pois_zi(integer(0)))
  expect_identical(ran_pois_zi(0L), integer(0))
  set.seed(101)
  expect_identical(ran_pois_zi(), 1L)
  expect_identical(ran_pois_zi(2), c(0L, 1L))
  expect_identical(ran_pois_zi(2, 10), c(11L, 8L))
  expect_identical(ran_pois_zi(2, c(0.1,100)), c(0L, 103L))
  expect_identical(ran_pois_zi(1, c(0.1,100)), 0L)
  set.seed(101)
  expect_identical(ran_pois_zi(10, 10, 0.5), c(0L, 11L, 7L, 8L, 0L, 0L, 0L, 10L, 0L, 0L))
})

test_that("ran_norm", {
  expect_error(ran_norm(NA_integer_))
  expect_error(ran_norm(integer(0)))
  expect_identical(ran_norm(0L), numeric(0))
  set.seed(101)
  expect_equal(ran_norm(), -0.326036490515386)
  expect_equal(ran_norm(2), c(0.552461855419139, -0.67494384395583))
  expect_equal(ran_norm(2, 10), c(10.2143594590434, 10.3107692173136))
  expect_equal(ran_norm(2, c(0.1,100)), c(1.2739662875627, 100.618789855626))
  expect_equal(ran_norm(1, c(0.1,100)), -0.0127343147542145)
})

test_that("ran_lnorm", {
  expect_error(ran_lnorm(NA_integer_))
  expect_error(ran_lnorm(integer(0)))
  expect_identical(ran_lnorm(0L), numeric(0))
  set.seed(101)
  expect_equal(ran_lnorm(), 0.721778848868975)
  expect_equal(ran_lnorm(2), c(1.73752529290614, 0.509185013620822))
  expect_equal(ran_lnorm(2, 10), c(27292.2882352846, 30054.546228237))
  expect_equal(ran_lnorm(2, c(0.1,100)), c(3.57500397331701, 4.99097288094876e+43))
  expect_equal(ran_lnorm(1, c(0.1,100)), 0.987346423552865)
})

test_that("ran_binom", {
  expect_error(ran_binom(NA_integer_))
  expect_error(ran_binom(integer(0)))
  expect_identical(ran_binom(0L), integer(0))
  set.seed(101)
  expect_identical(ran_binom(), 0L)
  expect_identical(ran_binom(2), c(0L, 1L))
  expect_identical(ran_binom(2, 10), c(6L, 4L))
  expect_identical(ran_binom(2, c(2,100)), c(1L, 47L))
  expect_identical(ran_binom(1, c(2,100)), 1L)
  expect_identical(ran_binom(1, 100, 0.1), 10L)
})

test_that("ran_bern", {
  expect_error(ran_bern(NA_integer_))
  expect_error(ran_bern(integer(0)))
  expect_identical(ran_bern(0L), integer(0))
  set.seed(101)
  expect_identical(ran_bern(), 0L)
  expect_identical(ran_bern(2), c(0L, 1L))
  expect_identical(ran_bern(2, c(0.1, 1)), c(0L, 1L))
  expect_identical(ran_bern(1, c(0.1, 1)), 0L)
})

test_that("ran_gamma_pois", {
  expect_error(ran_gamma_pois(NA_integer_))
  expect_error(ran_gamma_pois(integer(0)))
  expect_identical(ran_gamma_pois(0L), integer(0))
  set.seed(101)
  expect_identical(ran_gamma_pois(), 1L)
  expect_identical(ran_gamma_pois(2), c(0L, 2L))
  expect_identical(ran_gamma_pois(2, 10), c(14L, 7L))
  expect_identical(ran_gamma_pois(2, c(0.1,100)), c(0L, 108L))
  expect_identical(ran_gamma_pois(1, c(0.1,100)), 0L)
  set.seed(101)
  expect_identical(ran_gamma_pois(theta = 10), 0L)
  expect_identical(ran_gamma_pois(2, theta = 10), c(1L, 2L))
  expect_identical(ran_gamma_pois(2, 10, theta = 10), c(0L, 0L))
  expect_identical(ran_gamma_pois(2, 10, theta = 10), c(7L, 13L))
  expect_identical(ran_gamma_pois(2, c(0.1,100), theta = 1), c(0L, 12L))
  expect_identical(ran_gamma_pois(2, c(0.1,100), theta = 1), c(0L, 117L))
  expect_identical(ran_gamma_pois(1, c(0.1,100), theta = 1), 0L)
})

test_that("ran_neg_binom", {
  expect_error(ran_neg_binom(NA_integer_))
  expect_error(ran_neg_binom(integer(0)))
  expect_identical(ran_neg_binom(0L), integer(0))
  set.seed(101)
  expect_identical(ran_neg_binom(), 1L)
  expect_identical(ran_neg_binom(2), c(0L, 2L))
  expect_identical(ran_neg_binom(2, 10), c(14L, 7L))
  expect_identical(ran_neg_binom(2, c(0.1,100)), c(0L, 108L))
  expect_identical(ran_neg_binom(1, c(0.1,100)), 0L)
  set.seed(101)
  expect_identical(ran_neg_binom(theta = 10), 0L)
  expect_identical(ran_neg_binom(2, theta = 10), c(1L, 2L))
  expect_identical(ran_neg_binom(2, 10, theta = 10), c(0L, 0L))
  expect_identical(ran_neg_binom(2, 10, theta = 10), c(7L, 13L))
  expect_identical(ran_neg_binom(2, c(0.1,100), theta = 1), c(0L, 12L))
  expect_identical(ran_neg_binom(2, c(0.1,100), theta = 1), c(0L, 117L))
  expect_identical(ran_neg_binom(1, c(0.1,100), theta = 1), 0L)
})

test_that("ran_gamma_pois_zi", {
  expect_error(ran_gamma_pois_zi(NA_integer_))
  expect_error(ran_gamma_pois_zi(integer(0)))
  expect_identical(ran_gamma_pois_zi(0L), integer(0))
  set.seed(101)
  expect_identical(ran_gamma_pois_zi(), 1L)
  expect_identical(ran_gamma_pois_zi(2), c(0L, 2L))
  expect_identical(ran_gamma_pois_zi(2, 10), c(14L, 7L))
  expect_identical(ran_gamma_pois_zi(2, c(0.1,100)), c(0L, 108L))
  expect_identical(ran_gamma_pois_zi(1, c(0.1,100)), 0L)
  set.seed(101)
  expect_identical(ran_gamma_pois_zi(prob = 0.5), 0L)
  expect_identical(ran_gamma_pois_zi(2, prob = 0.5), c(1L, 1L))
  expect_identical(ran_gamma_pois_zi(2, 10, prob = 0.5), c(7L, 0L))
  expect_identical(ran_gamma_pois_zi(2, c(0.1,100), prob = 0.5), c(0L, 100L))
  expect_identical(ran_gamma_pois_zi(1, c(0.1,100), prob = 0.5), 0L)
  set.seed(101)
  expect_identical(ran_gamma_pois_zi(theta = 10), 0L)
  expect_identical(ran_gamma_pois_zi(2, theta = 10), c(1L, 2L))
  expect_identical(ran_gamma_pois_zi(2, 10, theta = 10), c(0L, 0L))
  expect_identical(ran_gamma_pois_zi(2, 10, theta = 10), c(7L, 13L))
  expect_identical(ran_gamma_pois_zi(2, c(0.1,100), theta = 1), c(0L, 12L))
  expect_identical(ran_gamma_pois_zi(2, c(0.1,100), theta = 1), c(0L, 117L))
  expect_identical(ran_gamma_pois_zi(1, c(0.1,100), theta = 1), 0L)
  set.seed(101)
  expect_identical(ran_gamma_pois_zi(theta = 10, prob = 0.5), 0L)
  expect_identical(ran_gamma_pois_zi(2, theta = 10, prob = 0.5), c(0L, 0L))
  expect_identical(ran_gamma_pois_zi(2, 10, theta = 10, prob = 0.5), c(9L, 0L))
  expect_identical(ran_gamma_pois_zi(2, 10, theta = 10, prob = 0.5), c(0L, 0L))
  expect_identical(ran_gamma_pois_zi(2, c(0.1,100), theta = 1, prob = 0.5), c(0L, 0L))
  expect_identical(ran_gamma_pois_zi(2, c(0.1,100), theta = 1, prob = 0.5), c(0L, 0L))
  expect_identical(ran_gamma_pois_zi(1, c(0.1,100), theta = 1, prob = 0.5), 0L)
})

test_that("ran_gamma", {
  expect_error(ran_gamma(NA_integer_))
  expect_error(ran_gamma(integer(0)))
  expect_identical(ran_gamma(0L), numeric(0))
  set.seed(101)
  expect_equal(ran_gamma(), 0.296032334929205)
  expect_equal(ran_gamma(2), c(0.828447196595941, 0.198011979729563))
  set.seed(101)
  expect_equal(ran_gamma(shape = 2), 1.12726342864167)
  expect_equal(ran_gamma(rate = 2), 0.41422359829797)
  expect_equal(ran_gamma(shape = 2, rate = 2), 0.463321963301684)
  expect_equal(ran_gamma(shape = 0.5), 1.25656793027554)
  expect_equal(ran_gamma(rate = 0.5), 2.06655144879794)
  expect_equal(ran_gamma(shape = 0.5, rate = 0.5), 1.88702952622222)
  set.seed(101)
  expect_equal(ran_gamma(1, shape = c(1, 2), rate = 0.5), 0.592064669858409)
  expect_equal(ran_gamma(1, rate = c(1, 2)), 0.828447196595941)
  expect_equal(ran_gamma(2, shape = c(1, 2), rate = c(1, 2)), c(0.198011979729563, 0.95237869084932))
})

test_that("ran_student", {
  expect_error(ran_student(NA_integer_))
  expect_error(ran_student(integer(0)))
  expect_error(ran_student(-1))
  expect_error(ran_student(0.1))
  expect_identical(ran_student(0L), numeric(0))
  set.seed(101)
  expect_equal(ran_student(), -0.326036490515386)
  expect_equal(ran_student(2), c(0.552461855419139, -0.67494384395583))
  expect_equal(ran_student(2, mean = 10), c(10.2143594590434, 10.3107692173136))
  expect_equal(ran_student(2, mean = c(0.1,100)), c(1.2739662875627, 100.618789855626))
  expect_equal(ran_student(2, sd = 10), c(-1.12734314754215, 9.17028289512712))
  expect_equal(ran_student(1, sd = c(0.1, 100)), -0.0223259364627263)
  expect_equal(ran_student(1, 5, 0), 5L)
  expect_equal(ran_student(1, 5, 0, 1), 5L)
  expect_equal(ran_student(2, mean = c(5, 10), sd = c(0.1, 1)), c(4.85331803058365, 9.7633166213971))
  expect_equal(ran_student(1, mean = c(5, 10), sd = c(0.1, 1)), 4.98066620350025)
  set.seed(101)
  expect_equal(ran_student(theta = 0.5), -0.33156105737203)
  expect_equal(ran_student(2, theta = 0.5), c(-0.828877594163717, 0.240144994036107))
  expect_equal(ran_student(2, 10, theta = 0.5), c(10.950902377826, 9.64745806982169))
  expect_equal(ran_student(2, c(0.1,100), theta = 0.5), c(-0.585038332110831, 101.180666799288))
  expect_equal(ran_student(1, c(0.1,100), theta = 0.5), 2.36756946562059)
  set.seed(101)
  expect_equal(ran_student(theta = 10), -1.87474739594541)
  expect_equal(ran_student(2, theta = 10), c(-26.8550547217203, 0.208423313901581))
  expect_equal(ran_student(2, 10, theta = 10), c(312.416238182549, 1232.50541097839))
  expect_equal(ran_student(2, c(0.1,100), theta = 1), c(1.57371753266519, 111.974370801549))
  expect_equal(ran_student(2, c(0.1,100), theta = 1), c(-0.233907776839805, 74.8346231062475))
  expect_equal(ran_student(1, c(0.1,100), theta = 1), 1.17304786153918)
  set.seed(101)
  expect_equal(ran_student(theta = 0.1), -0.304076815655304)
  expect_equal(ran_student(2, theta = 0.1), c(-0.677235928466201, 0.256581693475524))
  expect_equal(ran_student(2, 10, theta = 0.1), c(10.6700666098513, 8.63003697321142))
  expect_equal(ran_student(2, 10, 0.1, theta = 0.1), c(9.93731209896207, 9.83624845227821))
  expect_equal(ran_student(2, c(0.1,100), 10, theta = 0.1), c(-6.27604275569631, 83.3203568426077))
  expect_equal(ran_student(2, c(0.1,100), c(0.1, 100), theta = 0.1), c(0.0828946276667616, -31.2764527374883))
})

test_that("ran_beta_binom", {
  expect_error(ran_beta_binom(NA_integer_))
  expect_error(ran_beta_binom(integer(0)))
  expect_identical(ran_beta_binom(0L), integer(0))
  set.seed(101)
  expect_identical(ran_beta_binom(), 0L)
  expect_identical(ran_beta_binom(2), c(0L, 1L))
  expect_identical(ran_beta_binom(2, 10), c(6L, 4L))
  expect_identical(ran_beta_binom(2, c(5,10)), c(2L, 5L))
  expect_identical(ran_beta_binom(1, c(5,10)), 2L)
  set.seed(101)
  expect_identical(ran_beta_binom(prob = 0.2), 0L)
  expect_identical(ran_beta_binom(2, prob = 0.2), c(0L, 0L))
  expect_identical(ran_beta_binom(2, 10, prob = 0.2), c(2L, 1L))
  expect_identical(ran_beta_binom(2, c(5,10), prob = 0.2), c(0L, 2L))
  expect_identical(ran_beta_binom(1, c(5,10), prob = 0.2), 1L)
  expect_identical(ran_beta_binom(1, 0, prob = 0.2), 0L)
  expect_identical(ran_beta_binom(1, 0, prob = 0.9), 0L)
  set.seed(101)
  expect_identical(ran_beta_binom(theta = 10), 1L)
  expect_identical(ran_beta_binom(2, theta = 10), c(0L, 1L))
  expect_identical(ran_beta_binom(2, 10, theta = 10), c(0L, 10L))
  expect_identical(ran_beta_binom(2, 10, theta = 10), c(0L, 0L))
  expect_identical(ran_beta_binom(2, c(10,100), theta = 1), c(2L, 70L))
  expect_identical(ran_beta_binom(2, c(10,100), theta = 1), c(10L, 54L))
  expect_identical(ran_beta_binom(1, c(10,100), theta = 1), 6L)
  set.seed(101)
  expect_identical(ran_beta_binom(theta = 0.5, prob = 0.2), 1L)
  expect_identical(ran_beta_binom(2, theta = 0.5, prob = 0.2), c(0L, 1L))
  expect_identical(ran_beta_binom(2, 10, theta = 0.5, prob = 0.2), c(4L, 1L))
  expect_identical(ran_beta_binom(2, 10, theta = 0.5, prob = 0.2), c(0L, 5L))
  expect_identical(ran_beta_binom(2, c(10,100), theta = 1, prob = 0.2), c(0L, 0L))
  expect_identical(ran_beta_binom(2, c(10,100), theta = 1, prob = 0.2), c(0L, 64L))
  expect_identical(ran_beta_binom(1, c(10,100), theta = 1, prob = 0.2), 4L)
})
