% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_powercurves.R
\name{plot_powercurves}
\alias{plot_powercurves}
\title{Plots the output of test_twoway_nrange}
\usage{
plot_powercurves(
  power_over_nrange,
  target_power = NULL,
  title = NULL,
  target_line = TRUE,
  alpha_line = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{power_over_nrange}{data.frame with sample sizes and corresponding powers to be plotted}

\item{target_power}{Numeric. Desired power to be attained. Accepts values between 0 and 1, defaults to 0.8.}

\item{title}{Character. Title for the graph. Defaults to 'Power curve from exact ANOVA test'}

\item{target_line}{Logical. If FALSE no target line will be drawn. Overrides target_power. Default is TRUE.}

\item{alpha_line}{Logical. Should a dashed line at the set alpha level be drawn. Default is TRUE.}

\item{alpha}{Numeric. Type I error rate.}
}
\value{
Plot with power curves.
}
\description{
Internal function, called by test_twoway_nrange, to plot power against sample size.
}
\examples{

## 'cornorm_model' is created with the calculate_mean_matrix function
refmean <- 10
treateff <- 1.2
timeeff <- 0.75

treatgroups <- 3
treatgroups_names <- c("wt", "DrugA", "DrugB")

timepoints <- 4
timepoints_names <- paste0("t", 1:timepoints)

nameslist <- list(treatment=treatgroups_names, time=timepoints_names)

rho = 0.7

cornorm_model <- calculate_mean_matrix(refmean = refmean, fAeffect = treateff, fBeffect = timeeff,
nlfA = treatgroups, nlfB = timepoints,
rho = rho, withinf = "fB", label_list = nameslist)

nset <- seq(7, 14, 2)
cornorm_sim <- simulate_twoway_nrange(cornorm_model, nset, repeated_measurements=TRUE, nsims=5)

##used small number of iterations to reduce computation time

power_results <- test_power_overkn(cornorm_sim, test="rank", plot=TRUE)

}
