% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncated-normal-distribution.R
\name{TruncNormal}
\alias{TruncNormal}
\alias{dtnorm}
\alias{ptnorm}
\alias{qtnorm}
\alias{rtnorm}
\title{Truncated normal distribution}
\usage{
dtnorm(x, mu = 0, sigma = 1, a = -Inf, b = Inf, log = FALSE)

ptnorm(q, mu = 0, sigma = 1, a = -Inf, b = Inf, lower.tail = TRUE,
  log.p = FALSE)

qtnorm(p, mu = 0, sigma = 1, a = -Inf, b = Inf, lower.tail = TRUE,
  log.p = FALSE)

rtnorm(n, mu = 0, sigma = 1, a = -Inf, b = Inf)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma}{location and scale parameters. Scale must be positive.}

\item{a, b}{minimal and maximal boundries for truncation
(\code{-Inf} and \code{Inf} by default).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the truncated normal distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{\phi(z)}
            {\Phi(\frac{b-\mu}{\sigma}) - \Phi(\frac{a-\mu}{\sigma})}
}{
f(x) = \phi(z) / (\Phi((b-\mu)/\sigma) - \Phi((a-\mu)/\sigma))
}

Cumulative distribution function
\deqn{
F(x) = \frac{\Phi(z) - \Phi(\frac{a-\mu}{\sigma})}
            {\Phi(\frac{b-\mu}{\sigma}) - \Phi(\frac{a-\mu}{\sigma})}
}{
F(x) = (\Phi(z) - \Phi((a-\mu)/\sigma)) / (\Phi((b-\mu)/\sigma) - \Phi((a-\mu)/\sigma))
}

Quantile function
\deqn{
F^{-1}(p) = \Phi^{-1}\left(\Phi\left(\frac{a-\mu}{\sigma}\right) + p \times
                     \left[\Phi\left(\frac{b-\mu}{\sigma}\right) -
                     \Phi\left(\frac{a-\mu}{\sigma}\right)\right]\right)
}{
F^-1(p) = \Phi^-1(\Phi((a-\mu)/\sigma) + p * (\Phi((b-\mu)/\sigma) - \Phi((a-\mu)/\sigma)))
}

where \eqn{ z = \frac{x-\mu}{\sigma} }{ z = (x-\mu)/\sigma }.

For random generation algorithm described by Robert (1995) is used.
}
\examples{

x <- rtnorm(1e5, 5, 3, b = 7)
xx <- seq(-10, 10, by = 0.001)
hist(x, 100, freq = FALSE)
lines(xx, dtnorm(xx, 5, 3, b = 7), col = "red")
hist(ptnorm(x, 5, 3, b = 7))
plot(ecdf(x))
lines(xx, ptnorm(xx, 5, 3, b = 7), col = "red", lwd = 2)

}
\references{
Robert, C.P. (1995). Simulation of truncated normal variables.
Statistics and Computing 5(2): 121-125. \url{http://arxiv.org/abs/0907.4010}

Burkardt, J. (17 October 2014). The Truncated Normal Distribution. Florida State University.
\url{http://people.sc.fsu.edu/~jburkardt/presentations/truncated_normal.pdf}
}
\keyword{distribution}

