% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{qc}
\alias{qc}
\alias{qe}
\alias{text_expand}
\alias{subst}
\title{Create vector of characters from unquoted strings (variable names)}
\usage{
qc(...)

qe(...)

text_expand(..., delim = c("\\\\{", "\\\\}"))

subst(...)
}
\arguments{
\item{...}{characters in \code{text_expand}, unquoted names of variables in
\code{qc} or unquoted expressions in \code{qe}.}

\item{delim}{character vector of length 2 - pair of opening and closing
delimiters for the templating tags. By default it is curly brackets. Note
that \code{delim} will be used in the perl-style regular expression so you
need to escape special characters, e. g. use \code{"\\\{"} instead of
\code{"\{"}.}
}
\value{
Vector of characters
}
\description{
\itemize{
\item{\code{qc} }{It is often needed to address variables in the data.frame in the such 
manner: \code{dfs[ , c("var1", "var2", "var3")]}. \code{qc} ("quoted c") is a
shortcut for the such cases to reduce keystrokes. With \code{qc} you can write:
\code{dfs[ , qc(var1, var2, var3)]}.}
\item{\code{qe} }{returns list of expression. It is useful to create substitution list for \code{..$arg}.}
\item{\code{text_expand} }{is simple string interpolation function. It searches in its
arguments expressions in curly brackets \code{{expr}}, evaluate them and substitute with
the result of evaluation. See examples.}
}
}
\examples{

## qc
qc(a, b, c)
identical(qc(a, b, c), c("a", "b", "c"))

mtcars[, qc(am, mpg, gear)]

## text_expand
i = 1:5
text_expand("q{i}")

i = 1:3
j = 1:3
text_expand("q1_{i}_{j}")

data(iris)
text_expand("'iris' has {nrow(iris)} rows.")

## qe
qe(mrset(a1 \%to\% a6), mrset(b1 \%to\% b6), mrset(c1 \%to\% c6))
}
