% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.1-plCV.R
\name{plCV}
\alias{plCV}
\title{Perform Simple Cross-Validation}
\usage{
plCV(array, top, how, fold, ...)
}
\arguments{
\item{array}{Specifies the \code{ExprsArray} object to undergo cross-validation.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. A numeric vector can also be used
to indicate specific features by location, similar to a character vector.}

\item{how}{A character string. Specifies the \code{\link{build}} method to iterate.}

\item{fold}{A numeric scalar. Specifies the number of folds for cross-validation.
Set \code{fold = 0} to perform leave-one-out cross-validation.}

\item{...}{Arguments passed to the \code{how} method.}
}
\value{
A numeric scalar. The cross-validation accuracy.
}
\description{
Calculates v-fold or leave-one-out cross-validation without selecting a new
 set of features with each fold.
}
\details{
\code{plCV} performs v-fold or leave-one-out cross-validation for an
 \code{ExprsArray} object. The argument \code{fold} specifies the number
 of v-folds to use during cross-validation. Set \code{fold = 0} to perform
 leave-one-out cross-validation. This approach to cross-validation
 will work for \code{ExprsBinary} and \code{ExprsMulti} objects alike. The
 peformance metric used to measure cross-validation accuracy is the
 \code{acc} slot returned by \code{\link{calcStats}}.

This type of cross-validation is most appropriate if the \code{ExprsArray}
 has not undergone any prior feature selection. However, it may also have a role
 as an unbiased guide to parameter selection when embedded in
 \code{\link{plGrid}}. If using cross-validation in lieu of an independent test
 set in the setting of one or more feature selection methods, consider using
 a more "sophisticated" form of cross-validation as implemented in
 \code{\link{plMonteCarlo}} or \code{\link{plNested}}.

When calculating classifier performance with \code{\link{calcStats}}, this
 function forces \code{aucSkip = TRUE} and \code{plotSkip = TRUE}.
}
\seealso{
\code{\link{fs}}\cr
\code{\link{build}}\cr
\code{\link{doMulti}}\cr
\code{\link{exprso-predict}}\cr
\code{\link{plCV}}\cr
\code{\link{plGrid}}\cr
\code{\link{plGridMulti}}\cr
\code{\link{plMonteCarlo}}\cr
\code{\link{plNested}}
}

