% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powoFam.R
\name{powoFam}
\alias{powoFam}
\title{Extract species number of any plant family}
\usage{
powoFam(family,
        verbose = TRUE,
        save = FALSE,
        dir = "results_powoFam",
        filename = "output")
}
\arguments{
\item{family}{Either one family name or a vector of multiple families that
is present in POWO.}

\item{verbose}{Logical, if \code{FALSE}, a message showing each step during
the POWO search will not be printed in the console in full.}

\item{save}{Logical, if \code{TRUE}, the search results will be saved on disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_powoFam} and the searched results
will be saved within a subfolder named after the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{output}.}
}
\value{
A table with the following fields: family, genus_number (counting of
genera within the specified plant family), species_number (countig of species
within each genus), kew_id (the family code used in Kew's database),
powo_uri (the URI to access the family in POWO).
}
\description{
Produces a CSV file listing the number of species and genera
within the target botanical families of vascular plants available at
\href{https://powo.science.kew.org/}{Plants of the World Online (POWO)}.
}
\examples{
\dontrun{
library(expowo)

powoFam(family = "Lecythidaceae",
        save = FALSE,
        dir = "results_powoFam",
        filename = "Lecythidaceae_spp_number")
}

}
\seealso{
\code{\link{megaGen}}

\code{\link{topGen}}

\code{\link{powoGenera}}

\code{\link{powoSpecies}}

\code{\link{powoMap}}

\code{\link{POWOcodes}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
