% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_wcs_limit}
\alias{get_wcs_limit}
\title{Determination of the \dQuote{worst case scenario} (wcs) limit}
\usage{
get_wcs_limit(
  rl,
  sl,
  intercept,
  xform = c("no", "no"),
  shift = c(0, 0),
  ivl_side = "lower"
)
}
\arguments{
\item{rl}{A numeric value that specifies the release specification limit(s),
on the same scale as \code{sl} and \code{intercept}.}

\item{sl}{A numeric value that specifies the specification limit, on the same
scale as \code{rl} and \code{intercept}.}

\item{intercept}{A numeric value representing the intercept of a linear
regression model fitted to sample data, on the same scale as \code{rl}
and \code{sl}.}

\item{xform}{A vector of two character strings that specifies the
transformation of the response and the time variable. The default is
\dQuote{no} transformation, i.e. \code{c("no", "no")}, where the first
element specifies the transformation of the \eqn{x} variable and the
second element the transformation of the \eqn{y} variable. Valid
alternatives for \eqn{x} and/or \eqn{y} variable transformation are
\code{"log"} (natural logarithm), \code{"sqrt"} (square root) and
\code{"sq"} (square).}

\item{shift}{A vector of two values which will be added to the variables
\eqn{x} and/or \eqn{y} before they are transformed as specified by the
\code{xform} parameter, where the first element will be added to the
\eqn{x} variable and the second element to the \eqn{y} variable. The
purpose is to prevent an undefined state which could arise when variables
with values of \eqn{\leq 0} are log or square root transformed. The
default is \code{c(0, 0)}.}

\item{ivl_side}{A character string that specifies if the specification
limit, given that the limit has only one side, is an \dQuote{upper} or a
\dQuote{lower} bound, i.e. it is specified as either \code{"upper"} or
\code{"lower"}, respectively. The default is \code{"lower"}. If the
specification has two boundaries, then this parameter specifies the
preferred side. If no side is preferred over the other, \code{"both"} can
be used.}
}
\value{
A list with the following elements is returned:
\item{xform}{A vector of two character strings that specifies the
  transformation of the response and the time variable.}
\item{shift}{A vector of two values which has been added to the values of
  the transformed \eqn{x} and/or \eqn{y} variables (specified via the
  \code{xform} parameter).}
\item{delta.lim}{A numeric value or a numeric vector of the absolute
  difference(s) between \code{rl} and \code{sl}, if \code{xform[2] != "no"}
  on the transformed scale.}
\item{delta.lim.orig}{A numeric value or a numeric vector of the absolute
  difference(s) between \code{rl} and \code{sl} on the original scale.}
\item{wcs.lim}{A numeric value or a numeric vector of the worst case
  scenario (wcs) limit(s), if \code{xform[2] != "no"} on the transformed
  scale.}
\item{wcs.lim.orig}{A numeric value or a numeric vector of the worst case
  scenario (wcs) limit(s) on the original scale.}
}
\description{
The function \code{get_wcs_limit()} calculates \dQuote{worst case scenario}
(wcs) limit following the ARGPM Guidance \dQuote{Stability testing for
prescription medicines}.
}
\details{
The function \code{get_wcs_limit()} determines the \dQuote{worst
case scenario} (wcs) limit as is proposed by the Australian Regulatory
Guidelines for Prescription Medicines (ARGPM) guidance \dQuote{Stability
testing for prescription medicines}. According to this guideline, the shelf
life or expiry limit is estimated as the point where the upper or lower
limit of the 95\% confidence interval of the linear model fitted to the
data intersects the wcs limit. The wcs limit is obtained by
adding/subtracting the absolute difference of specification limit and
release limit to/from the common intercept of the test batches or the
intercept of the worst performing batch.

If data have been linearised by transformation, all elements, i.e. \code{rl},
\code{sl} and \code{intercept} must be on the same, i.e. transformed, scale.
The results are returned on the transformed scale and on the original scale.
}
\references{
Therapeutic Goods Administration (TGA) of the Department of Health of the
Australian Government, Australian Regulatory Guidelines for Prescription
Medicines (ARGPM), Stability testing for prescription medicines,
Version 1.1, March 2017
}
\seealso{
\code{\link{extract_from_ll_wcsl}},
\code{\link{get_wisle_poi_list}}, \code{\link{expirest_wisle}}.
}
\keyword{internal}
