% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_model_list}
\alias{get_model_list}
\title{Linear model fitting}
\usage{
get_model_list(data, response_vbl, time_vbl, batch_vbl)
}
\arguments{
\item{data}{A data frame with the columns specified by \code{response_vbl},
\code{time_vbl} and \code{batch_vbl}.}

\item{response_vbl}{A character string that specifies the response variable
name that must be a column of \code{data}.}

\item{time_vbl}{A character string that specifies the time variable name
that must be a column of \code{data}.}

\item{batch_vbl}{A character string that specifies the column in \code{data}
with the grouping information (i.e. a factorial variable) for the
differentiation of the observations of the various batches.}
}
\value{
A list of three elements is returned,
containing the following elements:
\item{Models}{A list of four elements named \code{cics}, \code{dics},
  \code{dids.pmse} and \code{dids}. The first three elements contain the
  \sQuote{\code{lm}} objects of the \dQuote{common intercept / common slope}
  (\code{cics}), \dQuote{different intercept / common slope} (\code{dics})
  and \dQuote{different intercept / different slope} (\code{dids}) models.
  The fourth element is a list of the \sQuote{\code{lm}} objects that is
  obtained from fitting a regression model to the data of each level of the
  categorical variable separately. The \code{cics}, \code{dics} and
  \code{dids.pmse} elements are \code{NA} if data of only a single batch
  is available.}
\item{AIC}{A numeric named vector of the Akaike Information Criterion (AIC)
  values of the \code{cics}, \code{dics} and \code{dids.pmse} models.}
\item{BIC}{A numeric named vector of the Bayesian Information Criterion (BIC)
  values of each of the \code{cics}, \code{dics} and \code{dids.pmse}
  models.}
}
\description{
The function \code{get_model_list()} fits four types of linear regression
models that are often used for the assessment of stability data, e.g. for
the estimation of the shelf life or retest period.
}
\details{
The function \code{get_model_list()} expects a data frame with
a response variable, a time variable and a categorical variable which
usually has factor levels of multiple batches of a drug product that was
assessed over a certain period of time with respect to the time-dependent
behaviour of characteristic parameters. Using these results, the function
fits
\itemize{
 \item a \emph{common intercept / common slope} model (cics),
 \item a \emph{different intercept / common slope} model (dics) or
 \item a \emph{different intercept / different slope} model with pooled
   mean square error (dids.pmse) and
 \item a \emph{different intercept / different slope} model (dids) in which
   individual models are fitted to each level of the categorical variable.
}

If the categorical variable has only a single factor level, then the first
three models are \code{NA} and only a single regression model is fitted.
}
\seealso{
\code{\link{expirest_osle}}, \code{\link{expirest_wisle}},
\code{\link[stats]{lm}}, \code{\link[stats]{AIC}}, \code{\link[stats]{BIC}}.
}
\keyword{internal}
