% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CACEcluster.R
\name{CACEcluster}
\alias{CACEcluster}
\title{Estimation of the Complier Average Causal Effects in Cluster-Randomized
Experiments with Unit-level Noncompliance}
\usage{
CACEcluster(Y, D, Z, grp, data = parent.frame(), match = NULL,
  weights = NULL, ...)
}
\arguments{
\item{Y}{The outcome variable of interest.}

\item{D}{The unit-level treatment receipt variable. This variable should be
binary but can differ across units within each cluster.}

\item{Z}{The (randomized) cluster-level encouragement variable. This
variable should be binary. Two units in the same cluster should have the
same value.}

\item{grp}{A variable indicating clusters of units. Two units in the same
cluster should have the same value.}

\item{data}{A data frame containing the relevant variables.}

\item{match}{A variable indicating matched-pairs of clusters. Two units in
the same matched-pair of clusters should have the same value. The default is
\code{NULL} (i.e., no matching).}

\item{weights}{A variable indicating the population cluster sizes, which
will be used to construct weights for each pair of clusters. Two units in
the same cluster should have the same value. The default is \code{NULL}, in
which case sample cluster sizes will be used for constructing weights.}

\item{...}{Optional arguments passed to \code{ATEcluster}, which is called
internally.}
}
\value{
A list of class \code{CACEcluster} which contains the following
items: \item{call}{ The matched call.  } \item{ITTY}{ The output object from
\code{ATEcluster} which is used to estimate the ITT effect of the
encouragement on the outcome variable.  } \item{ITTD}{ The output object
from \code{ATEcluster} which is used to estimate the ITT effect of the
encouragement on the treatment receipt variable.  } \item{n1}{ The total
number of units in the treatment group.  } \item{n0}{ The total number of
units in the control group.  } \item{Z}{ The treatment variable.  }
\item{est}{ The estimated complier average causal effect.  } \item{var}{ The
estimated variance of the complier average causal effect estimator.  }
\item{cov}{ The estimated covariance between two ITT estimator.  } \item{m}{
The number of pairs in the matched-pair design.  } \item{N1}{ The population
cluster sizes for the treatment group.  } \item{N0}{ The population cluster
sizes for the control group.  } \item{w}{ Pair-specific normalized
arithmetic mean weights. These weights sum up to the total number of units
in the sample, i.e., \code{n}.  }
}
\description{
This function estimates various complier average causal effect in
cluster-randomized experiments without using pre-treatment covariates when
unit-level noncompliance exists. Both the encouragement and treatment
variables are assumed to be binary. Currently, only the matched-pair design
is allowed. The details of the methods for this design are given in Imai,
King, and Nall (2007).
}
\references{
Imai, Kosuke, Gary King, and Clayton Nall (2007). \dQuote{The
Essential Role of Pair Matching in Cluster-Randomized Experiments, with
Application to the Mexican Universal Health Insurance Evaluation}, Technical
Report. Department of Politics, Princeton University.
}
\author{
Kosuke Imai, Department of Politics, Princeton University
\email{kimai@Princeton.Edu}, \url{http://imai.princeton.edu};
}
\keyword{design}
