% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfn_exdqlmISVB.R
\name{transfn_exdqlmISVB}
\alias{transfn_exdqlmISVB}
\title{Transfer Function exDQLM - ISVB algorithm}
\usage{
transfn_exdqlmISVB(
  y,
  p0,
  model,
  X,
  df,
  dim.df,
  lam,
  tf.df,
  fix.gamma = FALSE,
  gam.init = NA,
  fix.sigma = TRUE,
  sig.init = NA,
  dqlm.ind = FALSE,
  exps0,
  tol = 0.1,
  n.IS = 500,
  n.samp = 200,
  PriorSigma = NULL,
  PriorGamma = NULL,
  tf.m0 = rep(0, 2),
  tf.C0 = diag(1, 2),
  verbose = TRUE
)
}
\arguments{
\item{y}{A univariate time-series.}

\item{p0}{The quantile of interest, a value between 0 and 1.}

\item{model}{List of the state-space model including `GG`, `FF`, prior parameters `m0` and `C0`.}

\item{X}{A univariate time-series which will be the input of the transfer function component.}

\item{df}{Discount factors for each block.}

\item{dim.df}{Dimension of each block of discount factors.}

\item{lam}{Transfer function rate parameter lambda, a value between 0 and 1.}

\item{tf.df}{Discount factor(s) used for the transfer function component.}

\item{fix.gamma}{Logical value indicating whether to fix gamma at `gam.init`. Default is `FALSE`.}

\item{gam.init}{Initial value for gamma (skewness parameter), or value at which gamma will be fixed if `fix.gamma=TRUE`.}

\item{fix.sigma}{Logical value indicating whether to fix sigma at `sig.init`. Default is `TRUE`.}

\item{sig.init}{Initial value for sigma (scale parameter), or value at which sigma will be fixed if `fix.sigma=TRUE`.}

\item{dqlm.ind}{Logical value indicating whether to fix gamma at `0`, reducing the exDQLM to the special case of the DQLM. Default is `FALSE`.}

\item{exps0}{Initial value for dynamic quantile. If `exps0` is not specified, it is set to the DLM estimate of the `p0` quantile.}

\item{tol}{Tolerance for convergence of dynamic quantile estimates. Default is `tol=0.1`.}

\item{n.IS}{Number of particles for the importance sampling of joint variational distribution of sigma and gamma. Default is `n.IS=500`.}

\item{n.samp}{Number of samples to draw from the approximated posterior distribution. Default is `n.samp=200`.}

\item{PriorSigma}{List of parameters for inverse gamma prior on sigma; shape `a_sig` and scale `b_sig`. Default is an inverse gamma with mean 1 (or `sig.init` if provided) and variance 10.}

\item{PriorGamma}{List of parameters for truncated student-t prior on gamma; center `m_gam`, scale `s_gam` and degrees of freedom `df_gam`. Default is a standard student-t with 1 degree of freedom, truncated to the support of gamma.}

\item{tf.m0}{Prior mean of the transfer function component.}

\item{tf.C0}{Prior covariance of the transfer function component.}

\item{verbose}{Logical value indicating whether progress should be displayed.}
}
\value{
A list of the following is returned:
\itemize{
  \item `run.time` - Algorithm run time in seconds.
  \item `iter` - Number of iterations until convergence was reached.
  \item `dqlm.ind` - Logical value indicating whether gamma was fixed at `0`, reducing the exDQLM to the special case of the DQLM.
  \item `model` - List of the augmented state-space model including `GG`, `FF`, prior parameters `m0` and `C0`.
  \item `p0` - The quantile which was estimated.
  \item `df` - Discount factors used for each block, including transfer function component.
  \item `dim.df` - Dimension used for each block of discount factors, including transfer function component.
  \item `lam` - Transfer function rate parameter lambda.
  \item `sig.init` - Initial value for sigma, or value at which sigma was fixed if `fix.sigma=TRUE`.
  \item `seq.sigma` - Sequence of sigma estimated by the algorithm until convergence.
  \item `samp.theta` - Posterior sample of the state vector variational distribution.
  \item `samp.post.pred` - Sample of the posterior predictive distributions.
  \item `map.standard.forecast.errors` - MAP standardized one-step-ahead forecast errors.
  \item `samp.sigma` - Posterior sample of scale parameter sigma variational distribution.
  \item `samp.vts` - Posterior sample of latent parameters, v_t, variational distributions.
  \item `theta.out` - List containing the variational distribution of the state vector including filtered distribution parameters (`fm` and `fC`) and smoothed distribution parameters (`sm` and `sC`).
  \item `vts.out` - List containing the variational distributions of latent parameters v_t.
  \item `median.kt` - Median number of time steps until the effect of X_t is less than or equal to 1e-3.
}
If `dqlm.ind=FALSE`, the list also contains:
\itemize{
  \item `gam.init` - Initial value for gamma, or value at which gamma was fixed if `fix.gamma=TRUE`.
  \item `seq.gamma` - Sequence of gamma estimated by the algorithm until convergence.
  \item `samp.gamma` - Posterior sample of skewness parameter gamma variational distribution.
  \item `samp.sts` - Posterior sample of latent parameters, s_t, variational distributions.
  \item `gammasig.out` - List containing the IS estimate of the variational distribution of sigma and gamma.
  \item `sts.out` - List containing the variational distributions of latent parameters s_t.
}
Or if `dqlm.ind=TRUE`, the list also contains:
\itemize{
  \item `sig.out` - List containing the IS estimate of the variational distribution of sigma.
 }
}
\description{
The function applies an Importance Sampling Variational Bayes (ISVB) algorithm to estimate the posterior of an exDQLM with exponential decay transfer function component.
}
\examples{
\donttest{
y = scIVTmag[1:1095]
X = ELIanoms[1:1095]
trend.comp = polytrendMod(1,mean(y),10)
seas.comp = seasMod(365,c(1,2,4),C0=10*diag(6))
model = combineMods(trend.comp,seas.comp)
M1 = transfn_exdqlmISVB(y,p0=0.85,model=model,
                          X,df=c(1,1),dim.df = c(1,6),
                          gam.init=-3.5,sig.init=15,
                          lam=0.38,tf.df=c(0.97,0.97))
}

}
