% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{confint.kgaps}
\alias{confint.kgaps}
\title{Confidence intervals for the extremal index \eqn{\theta}}
\usage{
\method{confint}{kgaps}(object, parm = "theta", level = 0.95,
  interval_type = c("both", "norm", "lik"), conf_scale = c("theta",
  "log"), constrain = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{c("kgaps", "exdex")}, returned by
\code{\link{kgaps}}.}

\item{parm}{Specifies which parameter is to be given a confidence interval.
Here there is only one option: the extremal index \eqn{\theta}.}

\item{level}{The confidence level required.  A numeric scalar in (0, 1).}

\item{interval_type}{A character scalar: \code{"norm"} for intervals of
type (a), \code{"lik"} for intervals of type (b).}

\item{conf_scale}{A character scalar.  If \code{interval_type = "norm"} then
  \code{conf_scale} determines the scale on which we use approximate
  large-sample normality of the estimator to estimate confidence intervals.

  If \code{conf_scale = "theta"}
  then confidence intervals are estimated for \eqn{\theta} directly.
  If \code{conf_scale = "log"} then confidence intervals are first
  estimated for \eqn{\log\theta}{log\theta} and then transformed back
  to the \eqn{\theta}-scale.}

\item{constrain}{A logical scalar.  If \code{constrain = TRUE} then
any confidence limits that are greater than 1 are set to 1,
that is, they are constrained to lie in (0, 1].  Otherwise,
limits that are greater than 1 may be obtained.
If \code{constrain = TRUE} then any lower confidence limits that are
less than 0 are set to 0.}

\item{...}{Further arguments. None are used currently.}
}
\value{
A matrix with columns giving the lower and upper confidence limits.
  These are labelled as (1 - level)/2 and 1 - (1 - level)/2 in \%
  (by default 2.5\% and 97.5\%).
  The row names indicate the type of interval:
  \code{norm} for intervals based on large sample normality and \code{lik}
  for likelihood-based intervals.
}
\description{
\code{confint} method for objects of class \code{c("kgaps", "exdex")}.
Computes confidence intervals for \eqn{\theta} based on an object returned
from \code{\link{kgaps}}.  Two types of interval may be returned:
(a) intervals based on approximate large-sample normality of the estimator
of \eqn{\theta}, which are symmetric about the point estimate,
and (b) likelihood-based intervals.
}
\details{
Two type of interval are calculated: (a) an interval based on the
  approximate large sample normality of the estimator of \eqn{\theta}
  (if \code{conf_scale = "theta"}) or of \eqn{\log\theta}{log\theta}
  (if \code{conf_scale = "log"}) and (b) a likelihood-based interval,
  based on the approximate large sample chi-squared, with 1 degree of
  freedom, distribution of the log-likelihood ratio statistic.
}
\examples{
u <- quantile(newlyn, probs = 0.90)
theta <- kgaps(newlyn, u)
confint(theta)
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \url{https://doi.org/10.1214/09-AOAS292}
}
