% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdensity.R
\name{pdensity}
\alias{pdensity}
\alias{sample_density}
\title{Density Function}
\usage{
pdensity(x, size = 3, power = 1, tol = 1e-06)

sample_density(x, size = 3, power = 1, tol = 1e-06)
}
\arguments{
\item{x}{numeric: range of density with \eqn{a=min(x, na.rm=TRUE)} and \eqn{b=max(x, na.rm=TRUE)}}

\item{size}{numeric: number of elements to be sampled (without replacement) from x}

\item{power}{numeric: constant or linear density function}

\item{tol}{numeric: disallow for density coefficients near zero (default: \code{1e-6}). A negative value will permit zero coefficients.}
}
\value{
A list with:
\itemize{
\item \code{a} the minimum of the interval
\item \code{i} the maximum of the interval
\item \code{x} the \code{size} sampled values
\item \code{fx} the distribution function at \code{x}
\item \code{pcoeff} a polynomial (intercept = first value)
\item \code{qcoeff} indefinite integral of the polynomial (intercept = first value)
\item \code{pint} result of the \code{integral(pcoeff, c(a,b), 0:2)}
}
}
\description{
Creates a linear (\code{power=1}) or constant (\code{power=0}) density function in a interval \deqn{[a, b]} where
\code{a} and \code{b} are sampled from \code{x}. It samples \code{size} elements without replacement and computes
the value of the distribution function.
}
\examples{
pdensity(-5:5)
pdensity(-5:5, power=1)
}
