% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltip.R
\name{tooltip}
\alias{tooltip}
\alias{add_tooltip}
\title{Tooltip}
\usage{
tooltip(x, tooltip = NULL)

add_tooltip(x, tooltip = NULL)
}
\arguments{
\item{x}{an html_matrix object}

\item{tooltip}{character: text to show (default: \code{NULL})}
}
\value{
An html_matrix object
}
\description{
Adds a text tooltip to the HTML matrix.
}
\examples{
library("magrittr")
library("tools")
m    <- matrix(1:12, ncol=4)
hm   <- html_matrix_sk(m, title='', fmt=rep("\%f", ncol(m))) \%>\% 
          add_tooltip(sprintf("Table has \%0.f rows and \%0.f columns", nrow(.), ncol(.)))
if (interactive()) html <- toHTML(hm, browser=TRUE)
}
