% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{extract_examples}
\alias{extract_examples}
\title{Extract examples lines from the functions in a .R file of a package.}
\usage{
extract_examples(r_file_name, pkg_dir = ".")
}
\arguments{
\item{r_file_name}{The name of the \code{.R} file within \code{R/}. There's no need to
specify the file path (as \code{R/x.R}, but you can do this if you want), you
can just use \code{x.R} for whichever file \code{x} it is. You can also omit the \code{.R}
for convenience, however using the wrong case (e.g. \code{.r}) will produce an
error.}

\item{pkg_dir}{The directory of the R project for this package (defaults to
current directory). This is the parent directory of \code{R/} and \code{man/}.}
}
\value{
A list of character vectors.
}
\description{
In each \code{.R} file in the \code{R/} folder of a package project, for the functions
defined therein, there can corresponding examples in the \code{.Rd} files of the
man/` folder. This function extracts those examples into a list of character
vectors, one list element for each documented function.
}
\details{
Anything found within a \code{\\dontrun\{...\}} block is ignored.
}
\examples{
setwd(tempdir())
devtools::create("tempkg")
setwd("tempkg")
file.copy(system.file("extdata", c("exemplar.R", "exampletestr.R"),
                      package = "exampletestr"), "R")
devtools::document()
exampletestr::extract_examples("exemplar")
exampletestr::extract_examples("exemplar")
setwd("..")
filesstrings::dir.remove("tempkg")
\dontrun{
extract_examples("non_existent_file")}

}
