% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{JCRR}
\alias{JCRR}
\alias{JCRR.default}
\alias{JCRR.binary}
\alias{JCRR.nominal}
\title{Joint Correct Response Rate}
\usage{
JCRR(U, na = NULL, Z = NULL, w = NULL)

\method{JCRR}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{JCRR}{binary}(U, na = NULL, Z = NULL, w = NULL)

\method{JCRR}{nominal}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A matrix of joint correct response rates with exametrika class.
Each element (i,j) represents the proportion of students who correctly
answered both items i and j.
}
\description{
The joint correct response rate (JCRR) is the rate of students who passed
both items. This function is applicable only to binary response data.
For non-binary data, it will automatically redirect to the JSR function
with an appropriate message.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate JCRR using sample dataset J5S10
JCRR(J5S10)
}
