% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{ESTEP.rd}
\alias{ESTEP.rd}
\title{Calculate E-P-values based on LR statistic.}
\usage{
ESTEP.rd(n0, n1, psi = 0, J = NULL, sided = 1, dec.places = 10, prin = FALSE)
}
\arguments{
\item{n0}{control sample size}

\item{n1}{treatment sample size}

\item{psi}{null value of risk difference p1-p0}

\item{J}{index of single data set if desired}

\item{sided}{(1 or 2 sided test)}

\item{dec.places}{number of decimal places of output t-values and p-values.}

\item{prin}{outputs expected time and progress of calculation}
}
\value{
A list with elements \item{y0,y1}{data sets (scalar or vector)}
\item{oldP}{approximate p-value(s) before E-step} \item{T, P}{quasi-exact
P-value(s) and equivalent T-value(s)} \item{pmle}{profile ML estimates of
baseline probability} \item{index}{consistent code to select a single
outcome} \item{psi}{scalar null value of p1-p0}
}
\description{
Calculates all possible values of the E-P-value for testing p1-p0 greater
than a provided null value psi.
}
\details{
This function can take a long time for larger sample sizes. The computation
time is of order (n0*n1)^2.
}
\references{
C.J. Lloyd (2022) Exact samples sizes for clinical trials subject to
size and power constraints. Preprint. \doi{10.13140/RG.2.2.11828.94085}
}
\author{
Chris J. Lloyd
}
\keyword{internal}
