% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bel.R
\name{Bel}
\alias{Bel}
\title{Degree of belief of interval for a Gaussian random fuzzy number}
\usage{
Bel(x, y, GRFN)
}
\arguments{
\item{x}{The lower bound of the interval (may be a vector).}

\item{y}{The upper bound of the interval (may be a vector).}

\item{GRFN}{A Gaussian random fuzzy number, encoded as a list with components mu, sig
and h.}
}
\value{
The degree of belief of the interval.
}
\description{
\code{Bel} computes the degree of belief of an interval [x,y] for a given Gaussian
random fuzzy number.
}
\examples{
bel<-Bel(1,2,list(mu=2,sig=1,h=2))
print(bel)
}
\references{
Thierry Denoeux. Reasoning with fuzzy and uncertain evidence using epistemic random
fuzzy sets: general framework and practical models. Fuzzy Sets and Systems, Vol. 453,
Pages 1-36, 2023.
}
\seealso{
\code{\link{Belint}}, \code{\link{Pl}}, \code{\link{pl_contour}},
\code{\link{combination_GRFN}}
}
