% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestModularity.R
\name{TestModularity}
\alias{TestModularity}
\title{Test modularity hypothesis}
\usage{
TestModularity(
  cor.matrix,
  modularity.hypot,
  permutations = 1000,
  MHI = FALSE,
  ...,
  landmark.dim = NULL,
  withinLandmark = FALSE
)
}
\arguments{
\item{cor.matrix}{Correlation matrix}

\item{modularity.hypot}{Matrix of hypothesis. Each line represents a trait and each column a module.
if modularity.hypot[i,j] == 1, trait i is in module j.}

\item{permutations}{Number of permutations, to be passed to MantelModTest}

\item{MHI}{Indicates if test should use Modularity Hypothesis Index instead of AVG Ratio}

\item{...}{additional arguments passed to MantelModTest}

\item{landmark.dim}{Used if permutations should be performed maintaining landmark structure in geometric morphometric data. Either 2 for 2d data or 3 for 3d data. Default is NULL for non geometric morphometric data.}

\item{withinLandmark}{Logical. If TRUE within-landmark correlations are used in the calculation of matrix correlation. Only used if landmark.dim is passed, default is FALSE.}
}
\value{
Returns mantel correlation and associated probability for each modularity hypothesis, along with AVG+, AVG-, AVG Ratio for each module.
A total hypothesis combining all hypothesis is also tested.
}
\description{
Tests modularity hypothesis using cor.matrix matrix and trait groupings
}
\examples{
cor.matrix <- RandomMatrix(10)
rand.hypots <- matrix(sample(c(1, 0), 30, replace=TRUE), 10, 3)
mod.test <- TestModularity(cor.matrix, rand.hypots)

cov.matrix <- RandomMatrix(10, 1, 1, 10)
cov.mod.test <- TestModularity(cov.matrix, rand.hypots, MHI = TRUE)
nosize.cov.mod.test <- TestModularity(RemoveSize(cov.matrix), rand.hypots, MHI = TRUE)
}
\references{
Porto, Arthur, Felipe B. Oliveira, Leila T. Shirai, Valderes Conto, and Gabriel Marroig. 2009. "The Evolution of Modularity in the Mammalian Skull I: Morphological Integration Patterns and Magnitudes." Evolutionary Biology 36 (1): 118-35. doi:10.1007/s11692-008-9038-3.
}
\seealso{
\code{\link{MantelModTest}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{mantel}
\keyword{modularity}
