% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RevertMatrix.R
\name{RevertMatrix}
\alias{RevertMatrix}
\title{Revert Matrix}
\usage{
RevertMatrix(values, etd, scaled = TRUE)
}
\arguments{
\item{values}{vector of values to build matrix, each value corresponding 
to a score on the ordered set of eigentensors (up to the maximum number of 
eigentensors on the target decomposition); if there are less values than eigentensors 
provided in etd (see below), the function will assume zero as the value 
for the score in remaining eigentensors}

\item{etd}{Eigentensor decomposition of m covariance matrices for 
k traits (obtained from \code{\link{EigenTensorDecomposition}})}

\item{scaled}{should we treat each score as a value given in standard 
deviations for each eigentensor? Defaults to TRUE}
}
\value{
A symmetric covariance matrix with k traits
}
\description{
Constructs a covariance matrix based on scores over covariance matrix eigentensors.
}
\examples{

## we can use RevertMatrix to represent eigentensors using SRD to compare two matrices
## which differ with respect to their projections on a single directions

data(dentus)

dentus.vcv <- daply (dentus, .(species), function(x) cov(x[,-5]))

dentus.vcv <- aperm(dentus.vcv, c(2, 3, 1))

dentus.etd <- EigenTensorDecomposition(dentus.vcv, TRUE)

## calling RevertMatrix with a single value will use this value as the score
## on the first eigentensor and use zero as the value of remaining scores

low.et1 <- RevertMatrix(-1.96, dentus.etd, TRUE)
upp.et1 <- RevertMatrix(1.96, dentus.etd, TRUE)

srd.et1 <- SRD(low.et1, upp.et1)
 
plot(srd.et1)

## we can also look at the second eigentensor, by providing each call 
## of RevertMatrix with a vector of two values, the first being zero

low.et2 <- RevertMatrix(c(0, -1.96), dentus.etd, TRUE)
upp.et2 <- RevertMatrix(c(0, 1.96), dentus.etd, TRUE)

srd.et2 <- SRD(low.et2, upp.et2)
 
plot(srd.et2)

}
\references{
Basser P. J., Pajevic S. 2007. Spectral decomposition of a 4th-order 
covariance tensor: Applications to diffusion tensor MRI. Signal Processing. 87:220-236.

Hine E., Chenoweth S. F., Rundle H. D., Blows M. W. 2009. Characterizing 
the evolution of genetic variance using genetic covariance tensors. Philosophical 
transactions of the Royal Society of London. Series B, Biological sciences. 364:1567-78.
}
