% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSProjection.R
\name{RSProjection}
\alias{RSProjection}
\alias{PlotRSprojection}
\title{Random Skewers projection}
\usage{
RSProjection(cov.matrix.array, p = 0.95, num.vectors = 1000)

PlotRSprojection(rs_proj, cov.matrix.array, p = 0.95, ncols = 5)
}
\arguments{
\item{cov.matrix.array}{Array with dimentions traits x traits x populations x MCMCsamples}

\item{p}{significance treashhold for comparison of variation in each random direction}

\item{num.vectors}{number of random vectors}

\item{rs_proj}{output from RSProjection}

\item{ncols}{number of columns in plot}
}
\value{
projection of all matrices in all random vectors

set of random vectors and confidence intervals for the projections

eigen decomposition of the random vectors in directions with significant differences of variations
}
\description{
Uses Bayesian posterior samples of a set of covariance matrices to identify 
directions of the morphospace in which these matrices differ in their amount of genetic variance.
}
\examples{
library(magrittr)
# small MCMCsample to reduce run time, acctual sample should be larger 
data(dentus)
cov.matrices = dlply(dentus, .(species), function(x) lm(as.matrix(x[,1:4])~1)) \%>\% 
               laply(function(x) BayesianCalculateMatrix(x, samples = 50)$Ps)
cov.matrices = aperm(cov.matrices, c(3, 4, 1, 2))
\dontrun{
rs_proj = RSProjection(cov.matrices, p = 0.8)  
PlotRSprojection(rs_proj, cov.matrices, ncol = 5)
}

}
\references{
Aguirre, J. D., E. Hine, K. McGuigan, and M. W. Blows. "Comparing G: multivariate analysis of genetic variation in multiple populations." Heredity 112, no. 1 (2014): 21-29.
}
