\name{evd-internal}

\alias{fbvlog}
\alias{fbvalog}
\alias{fbvhr}
\alias{fbvneglog}
\alias{fbvaneglog}
\alias{fbvbilog}
\alias{fbvnegbilog}
\alias{fbvct}

\alias{pcint}
\alias{fgev.quantile}
\alias{fgev.norm}
\alias{fpot.quantile}
\alias{fpot.norm}
\alias{bvdepfn}
\alias{tvdepfn}
\alias{mvalog.check}
\alias{subsets}

\alias{ccop}
\alias{ccop.case}
\alias{mtransform}
\alias{na.vals}
\alias{bvpost.optim}
\alias{bvstart.vals}
\alias{nsloc.transform}
\alias{sep.bvdata}

\alias{dens}
\alias{pp}
\alias{qq}
\alias{rl}
\alias{dens.gev}
\alias{pp.gev}
\alias{qq.gev}
\alias{rl.gev}
\alias{dens.pot}
\alias{pp.pot}
\alias{qq.pot}
\alias{rl.pot}

\alias{bvdens}
\alias{bvcpp}
\alias{bvdp}

\alias{abvalog}
\alias{abvaneglog}
\alias{abvhr}
\alias{abvlog}
\alias{abvneglog}
\alias{abvbilog}
\alias{abvnegbilog}
\alias{abvct}

\alias{rbvlog}
\alias{rbvalog}
\alias{rbvhr}
\alias{rbvneglog}
\alias{rbvaneglog}
\alias{rbvbilog}
\alias{rbvnegbilog}
\alias{rbvct}

\alias{pbvlog}
\alias{pbvalog}
\alias{pbvhr}
\alias{pbvneglog}
\alias{pbvaneglog}
\alias{pbvbilog}
\alias{pbvnegbilog}
\alias{pbvct}

\alias{dbvlog}
\alias{dbvalog}
\alias{dbvhr}
\alias{dbvneglog}
\alias{dbvaneglog}
\alias{dbvbilog}
\alias{dbvnegbilog}
\alias{dbvct}

\alias{rmvlog}
\alias{rmvalog}
\alias{pmvlog}
\alias{pmvalog}
\alias{dmvlog}
\alias{dmvalog}
\alias{atvalog}
\alias{atvlog}

\alias{fbvcpot}
\alias{fbvppot}
\alias{bvtpost.optim}

\alias{fbvclog}
\alias{fbvcalog}
\alias{fbvcaneglog}
\alias{fbvcbilog}
\alias{fbvcct}
\alias{fbvcnegbilog}
\alias{fbvcneglog}
\alias{fbvchr}

\alias{fbvplog}
\alias{fbvpbilog}
\alias{fbvpct}
\alias{fbvpnegbilog}
\alias{fbvpneglog}

\title{Internal Functions}

\description{
  The evd package contains many internal functions that are not
  designed to be called by the user.

  The generic functions \code{dens}, \code{pp}, \code{qq} and
  \code{rl} create the diagnostic plots generated by
  \code{plot.uvevd}.
  Similarly, \code{bvdens}, \code{bvcpp} and \code{bvdp} create
  the diagnostic plots generated by \code{plot.bvevd}.

  There are internal fitting, simulation, distribution and density
  functions for each bivariate and multivariate parametric model,
  which are called from functions such as \code{rbvevd} and
  \code{rmvevd}. There also exists internal functions for the
  calculation and plotting of dependence functions of 
  bivariate and trivariate models, which are called from
  \code{abvdep} and \code{atvdep}.
  The dependence functions are ultimately plotted by the low-level
  functions \code{bvdepfn} and \code{tvdepfn}.
  
  The function \code{pcint} calculates profile confidence intervals,
  and is called from the function \code{plot.profile.evd}. The fitting
  function \code{fgev} calls the internal functions \code{fgev.quantile}
  and \code{fgev.norm} for fits under different parameterizations.
  The fitting function \code{fpot} calls the internal functions
  \code{fpot.norm} and \code{fpot.quantile}.
  Marginal transformations are executed using \code{mtransform}.
  
  The function \code{ccop} calculates condition copulas (i.e.
  conditional distributions under uniform margins) for each
  bivariate parametric model, and \code{ccop.case} does the
  same for when a case indicator is implemented, conditioning
  also on the case. They are needed to create the conditional
  P-P plots generated by \code{bvcpp}.

  The functions \code{nsloc.transform}, \code{na.vals},
  \code{bvpost.optim}, \code{bvstart.vals} and \code{sep.bvdata}
  are used in the fitting of bivariate models. The function
  \code{mvalog.check} checks and transforms the \code{asy} argument
  for the multivariate asymmetric model. The function
  \code{subsets} lists all subsets of \code{1:n}; it is
  called by \code{mvalog.check} and multivariate distribution
  functions.

  For fitting bivariate threshold models, internal functions exist
  for the censored and (currently unimplemented) point process
  likelihoods, and each of these calls a further internal function
  corresponding to the specified model. The internal function
  \code{bvtpost.optim} is then used for post optimization processing.
}

\keyword{internal}
